/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.utils.DatabaseManager;
import uk.co.finleyofthewoods.warpspeed.utils.TeleportUtils;
import uk.co.finleyofthewoods.warpspeed.utils.WarpPosition;

public class WarpCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarpCommand.class);
    private static final int MAX_WARP_PER_PLAYER = 254;

    private static SuggestionProvider<class_2168> accessibleWarpSuggestions(DatabaseManager dbManager) {
        return (context, builder) -> {
            try {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                List<String> warpNames = dbManager.getAccessibleWarpNames(player.method_5667());
                return WarpCommand.suggestMatching(warpNames, builder);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        };
    }

    private static SuggestionProvider<class_2168> playerWarpSuggestions(DatabaseManager dbManager) {
        return (context, builder) -> {
            try {
                class_3222 player = ((class_2168)context.getSource()).method_9207();
                List<String> warpNames = dbManager.getPlayerWarpNames(player.method_5667());
                return WarpCommand.suggestMatching(warpNames, builder);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        };
    }

    private static SuggestionProvider<class_2168> isPrivateSuggestion() {
        return (context, builder) -> WarpCommand.suggestMatching(Arrays.asList("false", "true"), builder);
    }

    private static CompletableFuture<Suggestions> suggestMatching(List<String> candidates, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        for (String candidate : candidates) {
            if (!candidate.toLowerCase().startsWith(remaining)) continue;
            builder.suggest(candidate);
        }
        return builder.buildFuture();
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, DatabaseManager dbManager) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"warpName", (ArgumentType)StringArgumentType.word()).suggests(WarpCommand.accessibleWarpSuggestions(dbManager)).executes(context -> WarpCommand.executeTeleportToWarp((CommandContext<class_2168>)context, dbManager))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setWarp").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"warpName", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"private", (ArgumentType)StringArgumentType.word()).suggests(WarpCommand.isPrivateSuggestion()).executes(context -> WarpCommand.executeSetWarp((CommandContext<class_2168>)context, dbManager)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delWarp").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"warpName", (ArgumentType)StringArgumentType.word()).suggests(WarpCommand.playerWarpSuggestions(dbManager)).executes(context -> WarpCommand.executeDeleteWarp((CommandContext<class_2168>)context, dbManager))));
    }

    private static int executeTeleportToWarp(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String warpName = StringArgumentType.getString(context, (String)"warpName");
            class_3218 world = player.method_51469();
            boolean success = TeleportUtils.teleportToWarp(player, (class_1937)world, warpName, dbManager);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Teleported to warp: " + warpName)), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to teleport to warp: " + warpName)), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /warp command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /warp command", (Throwable)e);
            return 0;
        }
    }

    private static int executeSetWarp(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String warpName = StringArgumentType.getString(context, (String)"warpName");
            if (warpName.length() > 32 || !warpName.matches("[a-zA-Z0-9_-]+")) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Warp name must be 1-32 alphanumeric characters"), false);
                return 0;
            }
            boolean privateFlag = StringArgumentType.getString(context, (String)"private").equals("true");
            boolean warpExists = dbManager.warpExists(warpName);
            if (warpExists) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + warpName + "' already exists")), false);
                return 0;
            }
            int warpCount = dbManager.getWarpCount(player.method_5667());
            if (warpCount >= 254) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You have reached the maximum number of warps (254)"), false);
                return 0;
            }
            class_2338 pos = player.method_24515();
            class_3218 world = player.method_51469();
            String worldId = world.method_27983().method_29177().toString();
            WarpPosition warp = new WarpPosition(player.method_5667(), warpName, worldId, privateFlag, pos.method_10263(), pos.method_10264(), pos.method_10260());
            boolean success = dbManager.saveWarp(warp);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + warpName + "' set at (" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ")")), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to set warp '" + warpName + "'")), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /setWarp command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /setWarp command", (Throwable)e);
            return 0;
        }
    }

    private static int executeDeleteWarp(CommandContext<class_2168> context, DatabaseManager dbManager) {
        try {
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_9207();
            String warpName = StringArgumentType.getString(context, (String)"warpName");
            boolean warpExists = dbManager.warpExists(warpName);
            if (!warpExists) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + warpName + "' does not exist")), false);
                return 0;
            }
            boolean success = dbManager.removeWarp(player.method_5667(), warpName);
            if (success) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Warp '" + warpName + "' deleted")), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("Failed to delete warp '" + warpName + "'")), false);
            return 0;
        }
        catch (CommandSyntaxException e) {
            LOGGER.error("Failed to execute /deleteWarp command", (Throwable)e);
            return 0;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Exception: Failed to execute /deleteWarp command", (Throwable)e);
            return 0;
        }
    }
}

