/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.utils;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.finleyofthewoods.warpspeed.utils.HomePosition;
import uk.co.finleyofthewoods.warpspeed.utils.WarpPosition;

public class DatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManager.class);
    private static final String DB_FILE = "config/warpspeed/warp_points.db";
    private Connection connection;

    public void initialise() {
        try {
            File dbFile = new File(DB_FILE);
            File parentDir = dbFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
                LOGGER.info("Created database directory {}", (Object)parentDir.getAbsolutePath());
            }
            this.connection = DriverManager.getConnection("jdbc:sqlite:config/warpspeed/warp_points.db");
            LOGGER.info("Connected to SQLite database: {}", (Object)DB_FILE);
            this.createTables();
        }
        catch (SecurityException e) {
            LOGGER.error("Failed to create database directory", (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to initialise database", (Throwable)e);
        }
    }

    private void ensureConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            LOGGER.warn("Database connection was closed, reopening...");
            String url = "jdbc:sqlite:config/warpspeed/warp_points.db";
            this.connection = DriverManager.getConnection(url);
            Statement stmt = this.connection.createStatement();
            stmt.execute("PRAGMA journal_mode=WAL;");
            stmt.execute("PRAGMA busy_timeout=5000;");
            stmt.close();
            LOGGER.info("Database connection re-established");
        }
    }

    private void createTables() throws SQLException {
        this.ensureConnection();
        String createHomesTableSQL = "    CREATE TABLE IF NOT EXISTS homes (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        player_uuid TEXT NOT NULL,\n        home_name TEXT NOT NULL,\n        world_id TEXT NOT NULL,\n        x INTEGER NOT NULL,\n        y INTEGER NOT NULL,\n        z INTEGER NOT NULL,\n        created_at INTEGER NOT NULL,\n        UNIQUE(player_uuid, home_name)\n    );\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createHomesTableSQL);
            LOGGER.info("Homes tables created or already exists");
        }
        String createHomesIndexSQL = "CREATE INDEX IF NOT EXISTS idx_player_homes ON homes(player_uuid);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createHomesIndexSQL);
            LOGGER.info("Homes index created or already exists");
        }
        String createWarpsTableSQL = "CREATE TABLE IF NOT EXISTS warps (\n  id INTEGER PRIMARY KEY AUTOINCREMENT,\n  player_uuid TEXT NOT NULL,\n  warp_name TEXT NOT NULL,\n  world_id TEXT NOT NULL,\n  x INTEGER NOT NULL,\n  y INTEGER NOT NULL,\n  z INTEGER NOT NULL,\n  is_private INTEGER NOT NULL,\n  created_at INTEGER NOT NULL,\n  UNIQUE(warp_name)\n);\n";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createWarpsTableSQL);
            LOGGER.info("Warps tables created or already exists");
        }
        String createWarpsIndexSQL = "CREATE INDEX IF NOT EXISTS idx_player_warps ON warps(player_uuid);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createWarpsIndexSQL);
            LOGGER.info("Warps index created or already exists");
        }
    }

    public boolean saveHome(HomePosition home) {
        boolean bl;
        block8: {
            String sql = "    INSERT INTO homes (player_uuid, home_name, world_id, x, y, z, created_at)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT(player_uuid, home_name)\n    DO UPDATE SET\n        world_id = excluded.world_id,\n        x = excluded.x,\n        y = excluded.y,\n        z = excluded.z,\n        created_at = excluded.created_at\n";
            this.ensureConnection();
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, home.getPlayerUUID().toString());
                pstmt.setString(2, home.getHomeName());
                pstmt.setString(3, home.getWorldId());
                pstmt.setInt(4, home.getX());
                pstmt.setInt(5, home.getY());
                pstmt.setInt(6, home.getZ());
                pstmt.setLong(7, home.getCreatedAt());
                int affected = pstmt.executeUpdate();
                LOGGER.debug("Saved home '{}' for player {}", (Object)home.getHomeName(), (Object)home.getPlayerUUID());
                boolean bl2 = bl = affected > 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to save home", (Throwable)e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HomePosition getHome(UUID playerUUID, String homeName) {
        String sql = "SELECT * FROM homes WHERE player_uuid = ? AND home_name = ? LIMIT 1";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUID.toString());
                pstmt.setString(2, homeName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    HomePosition homePosition2 = new HomePosition(UUID.fromString(rs.getString("player_uuid")), rs.getString("home_name"), rs.getString("world_id"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getLong("created_at"));
                    return homePosition2;
                }
                LOGGER.debug("Home '{}' not found", (Object)homeName);
                HomePosition homePosition = null;
                return homePosition;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get home", (Throwable)e);
            return null;
        }
    }

    public List<HomePosition> getPlayerHomes(UUID playerUUID) {
        ArrayList<HomePosition> homes = new ArrayList<HomePosition>();
        String sql = "SELECT * FROM homes WHERE player_uuid = ? ORDER BY home_name";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUID.toString());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    homes.add(new HomePosition(UUID.fromString(rs.getString("player_uuid")), rs.getString("home_name"), rs.getString("world_id"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getLong("created_at")));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get player homes", (Throwable)e);
            return homes;
        }
        if (homes.isEmpty()) {
            LOGGER.debug("No homes found for player {}", (Object)playerUUID);
        }
        return homes;
    }

    public boolean removeHome(UUID playerUUID, String homeName) {
        boolean bl;
        block8: {
            String sql = "DELETE FROM homes WHERE player_uuid = ? AND home_name = ?";
            this.ensureConnection();
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, playerUUID.toString());
                pstmt.setString(2, homeName);
                int affected = pstmt.executeUpdate();
                LOGGER.debug("Removed home '{}' for player {} (affected rows: {})", new Object[]{homeName, playerUUID, affected});
                boolean bl2 = bl = affected > 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to remove home", (Throwable)e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean homeExists(UUID playerUUID, String homeName) {
        String sql = "SELECT COUNT(*) FROM homes WHERE player_uuid = ? AND home_name = ?";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUID.toString());
                pstmt.setString(2, homeName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean bl2 = rs.getInt(1) > 0;
                    return bl2;
                }
                LOGGER.debug("Home '{}' not found", (Object)homeName);
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHomeCount(UUID playerUUID) {
        String sql = "SELECT COUNT(*) FROM homes WHERE player_uuid = ?";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUID.toString());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int n2 = rs.getInt(1);
                    return n2;
                }
                LOGGER.debug("No homes found for player {}", (Object)playerUUID);
                int n = 0;
                return n;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get home count", (Throwable)e);
            return 0;
        }
    }

    public boolean saveWarp(WarpPosition warp) {
        boolean bl;
        block8: {
            String sql = "INSERT INTO warps (player_uuid, warp_name, world_id, x, y, z, is_private, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            this.ensureConnection();
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, warp.getPlayerUUID().toString());
                pstmt.setString(2, warp.getWarpName());
                pstmt.setString(3, warp.getWorldId());
                pstmt.setInt(4, warp.getX());
                pstmt.setInt(5, warp.getY());
                pstmt.setInt(6, warp.getZ());
                pstmt.setBoolean(7, warp.isPrivate());
                pstmt.setLong(8, warp.getCreatedAt());
                int affected = pstmt.executeUpdate();
                LOGGER.debug("Saved warp '{}' for player {}", (Object)warp.getWarpName(), (Object)warp.getPlayerUUID());
                boolean bl2 = bl = affected > 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to save warp", (Throwable)e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean warpExists(String warpName) {
        String sql = "SELECT count(*) FROM warps WHERE warp_name = ?";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, warpName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean bl2 = rs.getInt(1) > 0;
                    return bl2;
                }
                LOGGER.debug("Warp '{}' not found", (Object)warpName);
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to check if warp exists", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getWarpCount(UUID playerUUUID) {
        String sql = "SELECT count(*) FROM warps WHERE player_uuid = ?";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUUID.toString());
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get warp count", (Throwable)e);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WarpPosition getWarp(String warpName) {
        String sql = "SELECT * FROM warps WHERE warp_name = ? LIMIT 1";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, warpName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    WarpPosition warpPosition2 = new WarpPosition(UUID.fromString(rs.getString("player_uuid")), rs.getString("warp_name"), rs.getString("world_id"), rs.getBoolean("is_private"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getLong("created_at"));
                    return warpPosition2;
                }
                LOGGER.debug("Warp '{}' not found", (Object)warpName);
                WarpPosition warpPosition = null;
                return warpPosition;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get warp", (Throwable)e);
            return null;
        }
    }

    public boolean removeWarp(UUID playerUuid, String warpName) {
        boolean bl;
        block8: {
            String sql = "DELETE FROM warps WHERE player_uuid = ? AND warp_name = ?";
            this.ensureConnection();
            PreparedStatement pstmt = this.connection.prepareStatement(sql);
            try {
                pstmt.setString(1, playerUuid.toString());
                pstmt.setString(2, warpName);
                int affected = pstmt.executeUpdate();
                LOGGER.debug("Removed warp '{}' for player {} (affected rows: {})", new Object[]{warpName, playerUuid, affected});
                boolean bl2 = bl = affected > 0;
                if (pstmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to remove warp", (Throwable)e);
                    return false;
                }
            }
            pstmt.close();
        }
        return bl;
    }

    public List<String> getAccessibleWarpNames(UUID playerUUID) {
        ArrayList<String> warpNames = new ArrayList<String>();
        String sql = "SELECT warp_name FROM warps WHERE is_private = 0 OR player_uuid = ? ORDER BY warp_name";
        try {
            this.ensureConnection();
            try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
                pstmt.setString(1, playerUUID.toString());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    warpNames.add(rs.getString("warp_name"));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get accessible warp names", (Throwable)e);
        }
        return warpNames;
    }

    public List<String> getPlayerWarpNames(UUID playerUUID) {
        ArrayList<String> warpNames = new ArrayList<String>();
        String sql = "SELECT warp_name FROM warps WHERE player_uuid = ? ORDER BY warp_name";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerUUID.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                warpNames.add(rs.getString("warp_name"));
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to get player warp names", (Throwable)e);
        }
        return warpNames;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                LOGGER.info("Database connection closed");
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to close database connection", (Throwable)e);
        }
    }
}

