/*
 * Decompiled with CFR 0.152.
 */
package uk.co.finleyofthewoods.warpspeed.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerLocationTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerLocationTracker.class);
    private static final Map<UUID, PlayerLocation> previousLocations = new HashMap<UUID, PlayerLocation>();
    private static final Map<UUID, PlayerLocation> deathLocations = new HashMap<UUID, PlayerLocation>();

    public static void storeCurrentLocation(class_3222 player) {
        UUID uuid = player.method_5667();
        class_2338 pos = player.method_24515();
        String worldId = player.method_51469().method_27983().method_29177().toString();
        PlayerLocation location = new PlayerLocation(pos.method_10263(), pos.method_10264(), pos.method_10260(), worldId);
        previousLocations.put(uuid, location);
        LOGGER.debug("Stored location for player {} at ({}, {}, {})", new Object[]{player.method_5477().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
    }

    public static void storeDeathLocation(class_3222 player) {
        UUID uuid = player.method_5667();
        class_2338 pos = player.method_24515();
        String worldId = player.method_51469().method_27983().method_29177().toString();
        PlayerLocation location = new PlayerLocation(pos.method_10263(), pos.method_10264(), pos.method_10260(), worldId);
        deathLocations.put(uuid, location);
        LOGGER.debug("Stored death location for player {} at ({}, {}, {})", new Object[]{player.method_5477().toString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
    }

    public static PlayerLocation getPreviousLocation(class_3222 player) {
        UUID uuid = player.method_5667();
        PlayerLocation deathLocation = deathLocations.get(uuid);
        if (deathLocation != null) {
            LOGGER.debug("Returning death location for player {} at ({}, {}, {})", new Object[]{player.method_5477().toString(), deathLocation.x, deathLocation.y, deathLocation.z});
            deathLocations.remove(uuid);
            return deathLocation;
        }
        return previousLocations.get(uuid);
    }

    public static boolean hasPreviousLocation(class_3222 player) {
        UUID uuid = player.method_5667();
        return previousLocations.containsKey(uuid) || deathLocations.containsKey(uuid);
    }

    public static void clearPreviousLocation(class_3222 player) {
        UUID uuid = player.method_5667();
        previousLocations.remove(uuid);
        deathLocations.remove(uuid);
    }

    public static class PlayerLocation {
        private final int x;
        private final int y;
        private final int z;
        private final String worldId;

        public PlayerLocation(int x, int y, int z, String worldId) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.worldId = worldId;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public class_2338 getBlockPos() {
            return new class_2338(this.x, this.y, this.z);
        }

        public String getWorldId() {
            return this.worldId;
        }
    }
}

