/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gildedsherds.common.impl;

import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.PotPatternAdapter;
import net.darkhax.gildedsherds.common.impl.SherdType;
import net.darkhax.gildedsherds.common.impl.config.ConfigProperty;
import net.minecraft.world.item.Item;

public class Content
implements ContentProvider {
    private static final String[] VANILLA_SHERDS = new String[]{"angler", "archer", "arms_up", "blade", "brewer", "burn", "danger", "explorer", "friend", "heart", "heartbreak", "howl", "miner", "mourner", "plenty", "prize", "sheaf", "shelter", "skull", "snort", "flow", "guster", "scrape"};
    private static final Supplier<List<SherdType>> SHERD_TYPES = CachedSupplier.cache(() -> {
        LinkedList<SherdType> types = new LinkedList<SherdType>();
        for (String vanillaType : VANILLA_SHERDS) {
            types.add(new SherdType("minecraft", vanillaType));
        }
        return types;
    });

    public String namespace() {
        return "gildedsherds";
    }

    public void defineItems(GameRegistryAdapter<Item> registry) {
        for (SherdType type : SHERD_TYPES.get()) {
            if (!type.canLoad()) continue;
            registry.add(type.itemId(), (Object)type.item());
        }
    }

    public void definePotPatterns(PotPatternAdapter registry) {
        for (SherdType type : SHERD_TYPES.get()) {
            if (!type.canLoad()) continue;
            registry.addWithItem(type.patternId(), type.item());
        }
    }

    public void defineLoadConditions(GenericRegistryAdapter<MapCodec<? extends ILoadCondition>> registry) {
        registry.add("config", ConfigProperty.CODEC);
    }
}

