/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gildedsherds.common.impl.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.bookshelf.common.api.data.conditions.ConditionType;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.gildedsherds.common.impl.GildedSherds;
import net.minecraft.resources.ResourceLocation;

public class ConfigProperty
implements ILoadCondition {
    public static final ResourceLocation TYPE_ID = GildedSherds.id("config");
    public static final CachedSupplier<ConditionType> TYPE = CachedSupplier.cache(() -> LoadConditions.getType((ResourceLocation)TYPE_ID));
    public static final MapCodec<ConfigProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapCodecs.STRING.get("property", ConfigProperty::getProperty)).apply((Applicative)instance, ConfigProperty::new));
    private static final Supplier<Map<String, Boolean>> PROPERTIES = CachedSupplier.cache(() -> {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("can_craft", GildedSherds.CONFIG.can_craft);
        properties.put("can_ungild", GildedSherds.CONFIG.can_ungild);
        properties.put("can_recycle", GildedSherds.CONFIG.can_recycle);
        properties.put("grant_advancement", GildedSherds.CONFIG.grant_advancement);
        return properties;
    });
    private final String property;

    private ConfigProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean allowLoading() {
        return PROPERTIES.get().containsKey(this.property) && PROPERTIES.get().get(this.property) != false;
    }

    public ConditionType getType() {
        return (ConditionType)TYPE.get();
    }
}

