/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.fabric;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import io.yukkuric.botania_overpowered.BotaniaOP;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class BotaniaOPConfigFabric
implements BotaniaOPConfig.CommonAccess {
    public static final BotaniaOPConfigFabric INSTANCE = new BotaniaOPConfigFabric();
    public final PropertyMirror<Boolean> cfg_showManaAmount = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_skipDandelifeonClearBoard = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_skipEntropinnyumDuperCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_enableEntropinnyumUnderwater = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_skipNarslimmusNaturalCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Short> cfg_ruleLifeGameNew = PropertyMirror.create((ConfigType)ConfigTypes.SHORT);
    public final PropertyMirror<Short> cfg_ruleLifeGameKeep = PropertyMirror.create((ConfigType)ConfigTypes.SHORT);

    @Override
    public boolean showManaAmount() {
        return (Boolean)this.cfg_showManaAmount.getValue();
    }

    @Override
    public boolean skipDandelifeonClearBoard() {
        return (Boolean)this.cfg_skipDandelifeonClearBoard.getValue();
    }

    @Override
    public int ruleLifeGameNew() {
        return ((Short)this.cfg_ruleLifeGameNew.getValue()).shortValue();
    }

    @Override
    public int ruleLifeGameKeep() {
        return ((Short)this.cfg_ruleLifeGameKeep.getValue()).shortValue();
    }

    @Override
    public boolean skipEntropinnyumDuperCheck() {
        return (Boolean)this.cfg_skipEntropinnyumDuperCheck.getValue();
    }

    @Override
    public boolean enableEntropinnyumUnderwater() {
        return (Boolean)this.cfg_enableEntropinnyumUnderwater.getValue();
    }

    @Override
    public boolean skipNarslimmusNaturalCheck() {
        return (Boolean)this.cfg_skipNarslimmusNaturalCheck.getValue();
    }

    public ConfigTree build(ConfigTreeBuilder builder) {
        builder.fork("display").beginValue("showManaAmount", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("displays the EVIL numbers").finishValue(arg_0 -> this.cfg_showManaAmount.mirror(arg_0)).finishBranch();
        builder.fork("features").fork("Dandelifeon").beginValue("skipDandelifeonClearBoard", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("no longer wipe all cells out when consuming").finishValue(arg_0 -> this.cfg_skipDandelifeonClearBoard.mirror(arg_0)).beginValue("ruleLifeGameNew", (ConfigType)ConfigTypes.SHORT, (Object)8).withComment("custom rule bitset for new cells").finishValue(arg_0 -> this.cfg_ruleLifeGameNew.mirror(arg_0)).beginValue("ruleLifeGameKeep", (ConfigType)ConfigTypes.SHORT, (Object)12).withComment("custom rule bitset for keeping cells").finishValue(arg_0 -> this.cfg_ruleLifeGameKeep.mirror(arg_0)).finishBranch().fork("Entropinnyum").beginValue("skipEntropinnyumDuperCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts TNTs from dupers").finishValue(arg_0 -> this.cfg_skipEntropinnyumDuperCheck.mirror(arg_0)).beginValue("enableEntropinnyumUnderwater", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts TNTs inside liquids").finishValue(arg_0 -> this.cfg_enableEntropinnyumUnderwater.mirror(arg_0)).finishBranch().fork("Narslimmus").beginValue("skipNarslimmusNaturalCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts ALL slimes").finishValue(arg_0 -> this.cfg_skipNarslimmusNaturalCheck.mirror(arg_0)).finishBranch().finishBranch();
        return builder.build();
    }

    public static void setup() {
        Closeable s;
        Path cfgPath;
        ConfigTree config;
        JanksonValueSerializer serializer;
        block19: {
            try {
                Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                BotaniaOP.LOGGER.warn("Failed to make config dir", (Throwable)e);
            }
            serializer = new JanksonValueSerializer(false);
            config = INSTANCE.build(ConfigTree.builder());
            cfgPath = Paths.get("config", "botania_overpowered-common.json5");
            File cfgFile = cfgPath.toFile();
            try {
                if (!cfgFile.exists()) break block19;
                s = new BufferedInputStream(Files.newInputStream(cfgPath, StandardOpenOption.READ, StandardOpenOption.CREATE));
                try {
                    FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
                }
                finally {
                    ((InputStream)s).close();
                }
            }
            catch (ValueDeserializationException | IOException e) {
                BotaniaOP.LOGGER.error("Error loading config from {}", (Object)cfgPath, (Object)e);
                try {
                    cfgPath.toFile().delete();
                }
                catch (Throwable ee) {
                    BotaniaOP.LOGGER.error("Error removing invalid config {}", (Object)cfgPath, (Object)ee);
                }
            }
        }
        try {
            s = new BufferedOutputStream(Files.newOutputStream(cfgPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
            try {
                FiberSerialization.serialize((ConfigTree)config, (OutputStream)s, (ValueSerializer)serializer);
            }
            finally {
                ((OutputStream)s).close();
            }
        }
        catch (IOException e) {
            BotaniaOP.LOGGER.error("Error writing back config {}", (Object)cfgPath, (Object)e);
        }
        BotaniaOPConfig.bindConfig(INSTANCE);
    }
}

