/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.forge.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.yukkuric.botania_overpowered.forge.BotaniaOPConfigForge;
import java.util.List;
import java.util.Locale;
import mekanism.client.render.armor.MekaSuitArmor;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.lib.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelHelmItem;

@Mixin(value={ItemMekaSuitArmor.class})
public class MixinTerraMekaSuit
extends ArmorItem
implements AncientWillContainer {
    public MixinTerraMekaSuit(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void addAncientWill(ItemStack stack, AncientWillContainer.AncientWillType willType) {
        if (!BotaniaOPConfigForge.MekasuitHelmetAcceptsAncientWill()) {
            return;
        }
        ((TerrasteelHelmItem)BotaniaItems.terrasteelHelm).addAncientWill(stack, willType);
    }

    public boolean hasAncientWill(ItemStack stack, AncientWillContainer.AncientWillType willType) {
        if (!BotaniaOPConfigForge.MekasuitHelmetAcceptsAncientWill() || this.f_40377_ != EquipmentSlot.HEAD) {
            return true;
        }
        return ((TerrasteelHelmItem)BotaniaItems.terrasteelHelm).hasAncientWill(stack, willType);
    }

    @Inject(method={"appendHoverText"}, at={@At(value="RETURN")})
    void addTooltipWhenShift(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag, CallbackInfo ci) {
        if (!BotaniaOPConfigForge.MekasuitHelmetAcceptsAncientWill() || this.f_40377_ != EquipmentSlot.HEAD || !Screen.m_96638_()) {
            return;
        }
        for (AncientWillContainer.AncientWillType sub : AncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, sub)) continue;
            tooltip.add((Component)Component.m_237115_((String)("botania.armorset.will_" + sub.name().toLowerCase(Locale.ROOT) + ".desc")).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Mixin(value={MekaSuitArmor.class})
    public static class AncientWillRendererExt {
        @Shadow(remap=false)
        @Final
        private EquipmentSlot type;

        @Inject(method={"renderMekaSuit"}, at={@At(value="RETURN")}, remap=false)
        void renderWillModel(HumanoidModel<? extends LivingEntity> baseModel, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, Color color, float partialTicks, boolean hasEffect, LivingEntity entity, CallbackInfo ci) {
            if (this.type != EquipmentSlot.HEAD || !BotaniaOPConfigForge.MekasuitHelmetAcceptsAncientWill()) {
                return;
            }
            ItemStack helm = entity.m_6844_(EquipmentSlot.HEAD);
            if (!TerrasteelHelmItem.hasAnyWill((ItemStack)helm)) {
                return;
            }
            matrix.m_85836_();
            baseModel.f_102808_.m_104299_(matrix);
            matrix.m_85837_(-0.2, -0.15, -0.3);
            matrix.m_85841_(0.4f, -0.4f, -0.4f);
            BakedModel model = MiscellaneousModels.INSTANCE.terrasteelHelmWillModel;
            VertexConsumer buffer = renderer.m_6299_(Sheets.m_110790_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(matrix.m_85850_(), buffer, (BlockState)null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
            matrix.m_85849_();
        }
    }

    @Mixin(value={TerrasteelHelmItem.class})
    public static class TerraHelmHooks {
        private static final EquipmentSlot[] armorSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

        private static boolean hasTerraMekaSuitSet(Player player) {
            if (!BotaniaOPConfigForge.MekasuitHelmetAcceptsAncientWill()) {
                return false;
            }
            for (EquipmentSlot slot : armorSlots) {
                if (player.m_6844_(slot).m_41720_() instanceof ItemMekaSuitArmor) continue;
                return false;
            }
            return true;
        }

        @Inject(method={"hasTerraArmorSet"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
        private static void MekasuitIsTerrasteel(Player player, CallbackInfoReturnable<Boolean> cir) {
            if (TerraHelmHooks.hasTerraMekaSuitSet(player)) {
                cir.setReturnValue((Object)true);
            }
        }

        @WrapOperation(method={"getCritDamageMult", "onEntityAttacked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")})
        private static Item wrapInstanceCheck(ItemStack instance, Operation<Item> original) {
            return BotaniaItems.terrasteelHelm;
        }
    }
}

