/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin;

import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.mixin_interface.PylonPumpExt;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.helper.MathHelper;

@Mixin(value={PylonBlockEntity.class})
public class MixinPylonPump
extends BlockEntity
implements WandBindable,
PylonPumpExt {
    @Shadow(remap=false)
    private int ticks;
    private BlockPos bindPos = null;
    private BlockPos cachedPos;

    public MixinPylonPump(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public boolean canSelect(Player player, ItemStack itemStack, BlockPos blockPos, Direction direction) {
        return BotaniaOPConfig.enablesManaPylonPump();
    }

    public boolean bindTo(Player foo, ItemStack bar, BlockPos newPos, Direction baz) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return false;
        }
        if (!this.isValidBindingPos(newPos) || this.f_58858_.m_7495_().equals((Object)newPos)) {
            newPos = null;
        }
        if (!Objects.equals(newPos, this.bindPos)) {
            this.bindPos = newPos;
            this.m_6596_();
        }
        return true;
    }

    @Nullable
    public BlockPos getBinding() {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return null;
        }
        return this.bindPos;
    }

    private boolean isValidBindingPos(BlockPos pos) {
        if (this.f_58857_ == null || !this.f_58857_.m_46749_(pos)) {
            return false;
        }
        int maxDist = BotaniaOPConfig.pylonPumpMaxRange();
        if (MathHelper.distSqr((Vec3i)this.f_58858_, (Vec3i)pos) > (long)(maxDist * maxDist)) {
            return false;
        }
        return this.getBoundTargetAt(pos) != null;
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128425_("pos", 10)) {
            this.bindPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.bindPos != null) {
            tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.bindPos));
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag res = new CompoundTag();
        this.m_183515_(res);
        return res;
    }

    private ManaReceiver getBoundTargetAt(BlockPos target) {
        if (target == null || this.f_58857_ == null) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(target);
        if (!(be instanceof ManaReceiver)) {
            return null;
        }
        ManaReceiver pool = (ManaReceiver)be;
        return pool;
    }

    @Override
    public ManaReceiver getBoundTarget() {
        return this.getBoundTargetAt(this.bindPos);
    }

    @Override
    public ManaReceiver getSource() {
        ManaReceiver target;
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.cachedPos == null || this.ticks % 20 == 0) {
            BlockPos.MutableBlockPos ptr = this.f_58858_.m_7495_().m_122032_();
            int py = ptr.m_123342_();
            while (this.f_58857_.m_46739_((BlockPos)ptr)) {
                BlockEntity be = this.f_58857_.m_7702_((BlockPos)ptr);
                if (be instanceof ManaReceiver) {
                    ManaReceiver target2 = (ManaReceiver)be;
                    this.cachedPos = ptr.m_7949_();
                    return target2;
                }
                if (!(be instanceof PylonBlockEntity)) break;
                ptr.m_142448_(--py);
            }
            this.cachedPos = this.f_58858_;
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(this.cachedPos);
        return be instanceof ManaReceiver ? (target = (ManaReceiver)be) : null;
    }

    @Override
    public Vec3 getBoundCenter() {
        return Vec3.m_82512_((Vec3i)this.bindPos);
    }

    @Inject(method={"commonTick"}, at={@At(value="RETURN")}, remap=false)
    private static void tickPump(Level level, BlockPos worldPosition, BlockState state, PylonBlockEntity self, CallbackInfo ci) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return;
        }
        ManaReceiver srcPool = ((PylonPumpExt)self).getSource();
        if (srcPool == null) {
            return;
        }
        ManaReceiver targetPool = ((PylonPumpExt)self).getBoundTarget();
        if (targetPool == null || targetPool.isFull()) {
            return;
        }
        int extractAmount = BotaniaOPConfig.pylonPumpSpeed();
        int reachedAmount = (int)Math.round((double)(extractAmount = Math.min(extractAmount, srcPool.getCurrentMana())) * (1.0 - BotaniaOPConfig.pylonPumpLossRatio()));
        if (reachedAmount <= 0) {
            return;
        }
        int oldMana = targetPool.getCurrentMana();
        targetPool.receiveMana(reachedAmount);
        int reachedReal = targetPool.getCurrentMana() - oldMana;
        if (reachedReal != reachedAmount) {
            extractAmount = (int)Math.ceil((float)extractAmount * (float)reachedReal / (float)reachedAmount);
        }
        srcPool.receiveMana(-extractAmount);
        if (level.f_46443_ && extractAmount > 0 && BotaniaOPConfig.enablesPylonPumpFx()) {
            PylonBlock.Variant variant = ((PylonBlock)state.m_60734_()).variant;
            Vec3 start = Vec3.m_82512_((Vec3i)worldPosition);
            Vec3 end = ((PylonPumpExt)self).getBoundCenter();
            Vec3 dir = end.m_82546_(start).m_82541_().m_82490_(0.5);
            start = start.m_82549_(dir);
            end = end.m_82546_(dir);
            for (int i = 0; i < BotaniaOPConfig.pylonPumpFxStrength(); ++i) {
                WispParticleData particle = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)variant.r, (float)variant.g, (float)variant.b, (float)0.5f).withNoClip(true);
                double mid = Math.random();
                double speed = Math.random() * 0.2;
                level.m_7106_((ParticleOptions)particle, Mth.m_14139_((double)mid, (double)start.f_82479_, (double)end.f_82479_), Mth.m_14139_((double)mid, (double)start.f_82480_, (double)end.f_82480_), Mth.m_14139_((double)mid, (double)start.f_82481_, (double)end.f_82481_), speed * dir.f_82479_, speed * dir.f_82480_, speed * dir.f_82481_);
            }
        }
    }
}

