/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.fabric;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import io.yukkuric.botania_overpowered.BotaniaOP;
import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class BotaniaOPConfigFabric
implements BotaniaOPConfig.CommonAccess {
    public static final BotaniaOPConfigFabric INSTANCE = new BotaniaOPConfigFabric();
    public final PropertyMirror<Boolean> cfg_showManaAmount = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_skipDandelifeonClearBoard = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Integer> cfg_ruleLifeGameNew = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public final PropertyMirror<Integer> cfg_ruleLifeGameKeep = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public final PropertyMirror<Boolean> cfg_skipEntropinnyumDuperCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_enableEntropinnyumUnderwater = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_skipNarslimmusNaturalCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_heatsBlazeBurner = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_enablesManaPylonPump = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Integer> cfg_pylonPumpMaxRange = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public final PropertyMirror<Integer> cfg_pylonPumpSpeed = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public final PropertyMirror<Double> cfg_pylonPumpLossRatio = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
    public final PropertyMirror<Boolean> cfg_enablesPylonPumpFx = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Integer> cfg_pylonPumpFxStrength = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
    public final PropertyMirror<Boolean> cfg_enablesPassiveThermalily = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_enchantBooks = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_acceptsAllInsideBook = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
    public final PropertyMirror<Boolean> cfg_ignoresCompatibleCheck = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

    @Override
    public boolean showManaAmount() {
        return (Boolean)this.cfg_showManaAmount.getValue();
    }

    @Override
    public boolean skipDandelifeonClearBoard() {
        return (Boolean)this.cfg_skipDandelifeonClearBoard.getValue();
    }

    @Override
    public int ruleLifeGameNew() {
        return (Integer)this.cfg_ruleLifeGameNew.getValue();
    }

    @Override
    public int ruleLifeGameKeep() {
        return (Integer)this.cfg_ruleLifeGameKeep.getValue();
    }

    @Override
    public boolean skipEntropinnyumDuperCheck() {
        return (Boolean)this.cfg_skipEntropinnyumDuperCheck.getValue();
    }

    @Override
    public boolean enableEntropinnyumUnderwater() {
        return (Boolean)this.cfg_enableEntropinnyumUnderwater.getValue();
    }

    @Override
    public boolean skipNarslimmusNaturalCheck() {
        return (Boolean)this.cfg_skipNarslimmusNaturalCheck.getValue();
    }

    @Override
    public boolean heatsBlazeBurner() {
        return (Boolean)this.cfg_heatsBlazeBurner.getValue();
    }

    @Override
    public boolean enablesManaPylonPump() {
        return (Boolean)this.cfg_enablesManaPylonPump.getValue();
    }

    @Override
    public int pylonPumpMaxRange() {
        return (Integer)this.cfg_pylonPumpMaxRange.getValue();
    }

    @Override
    public int pylonPumpSpeed() {
        return (Integer)this.cfg_pylonPumpSpeed.getValue();
    }

    @Override
    public double pylonPumpLossRatio() {
        return (Double)this.cfg_pylonPumpLossRatio.getValue();
    }

    @Override
    public boolean enablesPylonPumpFx() {
        return (Boolean)this.cfg_enablesPylonPumpFx.getValue();
    }

    @Override
    public int pylonPumpFxStrength() {
        return (Integer)this.cfg_pylonPumpFxStrength.getValue();
    }

    @Override
    public boolean enablesPassiveThermalily() {
        return (Boolean)this.cfg_enablesPassiveThermalily.getValue();
    }

    @Override
    public boolean enchantBooks() {
        return (Boolean)this.cfg_enchantBooks.getValue();
    }

    @Override
    public boolean acceptsAllInsideBook() {
        return (Boolean)this.cfg_acceptsAllInsideBook.getValue();
    }

    @Override
    public boolean ignoresCompatibleCheck() {
        return (Boolean)this.cfg_ignoresCompatibleCheck.getValue();
    }

    public ConfigTree build(ConfigTreeBuilder builder) {
        builder.fork("Display").beginValue("showManaAmount", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("displays the EVIL numbers").finishValue(arg_0 -> this.cfg_showManaAmount.mirror(arg_0)).finishBranch();
        builder.fork("Dandelifeon").beginValue("skipDandelifeonClearBoard", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("no longer wipe all cells out when consuming").finishValue(arg_0 -> this.cfg_skipDandelifeonClearBoard.mirror(arg_0)).beginValue("ruleLifeGameNew", (ConfigType)ConfigTypes.INTEGER, (Object)8).withComment("custom rule bitset for new cells").finishValue(arg_0 -> this.cfg_ruleLifeGameNew.mirror(arg_0)).beginValue("ruleLifeGameKeep", (ConfigType)ConfigTypes.INTEGER, (Object)12).withComment("custom rule bitset for keeping cells").finishValue(arg_0 -> this.cfg_ruleLifeGameKeep.mirror(arg_0)).finishBranch();
        builder.fork("Entropinnyum").beginValue("skipEntropinnyumDuperCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts TNTs from dupers").finishValue(arg_0 -> this.cfg_skipEntropinnyumDuperCheck.mirror(arg_0)).beginValue("enableEntropinnyumUnderwater", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts TNTs inside liquids").finishValue(arg_0 -> this.cfg_enableEntropinnyumUnderwater.mirror(arg_0)).finishBranch();
        builder.fork("Narslimmus").beginValue("skipNarslimmusNaturalCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts ALL slimes").finishValue(arg_0 -> this.cfg_skipNarslimmusNaturalCheck.mirror(arg_0)).finishBranch();
        builder.fork("Exoflame").beginValue("heatsBlazeBurner", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("heats Blaze Burner blocks from Create").finishValue(arg_0 -> this.cfg_heatsBlazeBurner.mirror(arg_0)).finishBranch();
        builder.fork("ManaPylonPump").beginValue("enablesManaPylonPump", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("makes Mana Pylons extract mana from the pool below and dump to wand-bound mana pool").finishValue(arg_0 -> this.cfg_enablesManaPylonPump.mirror(arg_0)).beginValue("pylonPumpMaxRange", (ConfigType)ConfigTypes.INTEGER, (Object)64).withComment("max distance between the pylon and the pool bound").finishValue(arg_0 -> this.cfg_pylonPumpMaxRange.mirror(arg_0)).beginValue("pylonPumpSpeed", (ConfigType)ConfigTypes.INTEGER, (Object)10000).withComment("how many mana points will be extracted each tick (for reference, each spark pair has speed of 1000)").finishValue(arg_0 -> this.cfg_pylonPumpSpeed.mirror(arg_0)).beginValue("pylonPumpLossRatio", (ConfigType)ConfigTypes.DOUBLE, (Object)0.1).withComment("how much ratio of mana will vanish during the transport").finishValue(arg_0 -> this.cfg_pylonPumpLossRatio.mirror(arg_0)).beginValue("enablesPylonPumpFx", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("displays extra particles when the pylon pump works").finishValue(arg_0 -> this.cfg_enablesPylonPumpFx.mirror(arg_0)).beginValue("pylonPumpFxStrength", (ConfigType)ConfigTypes.INTEGER, (Object)3).withComment("how thick the pump particle line will be").finishValue(arg_0 -> this.cfg_pylonPumpFxStrength.mirror(arg_0)).finishBranch();
        builder.fork("Thermalily").beginValue("enablesPassiveThermalily", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("no longer consumes lava during its cooldown").finishValue(arg_0 -> this.cfg_enablesPassiveThermalily.mirror(arg_0)).finishBranch();
        builder.fork("ManaEnchanter").beginValue("enchantBooks", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("may enchant books as enchantment table does").finishValue(arg_0 -> this.cfg_enchantBooks.mirror(arg_0)).beginValue("acceptsAllInsideBook", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("all available enchantments will be accepted, not onlt the first").finishValue(arg_0 -> this.cfg_acceptsAllInsideBook.mirror(arg_0)).beginValue("ignoresCompatibleCheck", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("accepts conflicted enchantments (for example, infinity & mending)").finishValue(arg_0 -> this.cfg_ignoresCompatibleCheck.mirror(arg_0)).finishBranch();
        return builder.build();
    }

    public static void setup() {
        Closeable s;
        Path cfgPath;
        ConfigTree config;
        JanksonValueSerializer serializer;
        block19: {
            try {
                Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                BotaniaOP.LOGGER.warn("Failed to make config dir", (Throwable)e);
            }
            serializer = new JanksonValueSerializer(false);
            config = INSTANCE.build(ConfigTree.builder());
            cfgPath = Paths.get("config", "botania_overpowered-common.json5");
            File cfgFile = cfgPath.toFile();
            try {
                if (!cfgFile.exists()) break block19;
                s = new BufferedInputStream(Files.newInputStream(cfgPath, StandardOpenOption.READ, StandardOpenOption.CREATE));
                try {
                    FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
                }
                finally {
                    ((InputStream)s).close();
                }
            }
            catch (ValueDeserializationException | IOException e) {
                BotaniaOP.LOGGER.error("Error loading config from {}", (Object)cfgPath, (Object)e);
                try {
                    cfgPath.toFile().delete();
                }
                catch (Throwable ee) {
                    BotaniaOP.LOGGER.error("Error removing invalid config {}", (Object)cfgPath, (Object)ee);
                }
            }
        }
        try {
            s = new BufferedOutputStream(Files.newOutputStream(cfgPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
            try {
                FiberSerialization.serialize((ConfigTree)config, (OutputStream)s, (ValueSerializer)serializer);
            }
            finally {
                ((OutputStream)s).close();
            }
        }
        catch (IOException e) {
            BotaniaOP.LOGGER.error("Error writing back config {}", (Object)cfgPath, (Object)e);
        }
        BotaniaOPConfig.bindConfig(INSTANCE);
    }
}

