/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin;

import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.mixin_interface.PylonPumpExt;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.helper.MathHelper;

@Mixin(value={PylonBlockEntity.class})
public class MixinPylonPump
extends class_2586
implements WandBindable,
PylonPumpExt {
    @Shadow(remap=false)
    private int ticks;
    private class_2338 bindPos = null;
    private class_2338 cachedPos;

    public MixinPylonPump(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public boolean canSelect(class_1657 player, class_1799 itemStack, class_2338 blockPos, class_2350 direction) {
        return BotaniaOPConfig.enablesManaPylonPump();
    }

    public boolean bindTo(class_1657 foo, class_1799 bar, class_2338 newPos, class_2350 baz) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return false;
        }
        if (!this.isValidBindingPos(newPos) || this.field_11867.method_10074().equals((Object)newPos)) {
            newPos = null;
        }
        if (!Objects.equals(newPos, this.bindPos)) {
            this.bindPos = newPos;
            this.method_5431();
        }
        return true;
    }

    @Nullable
    public class_2338 getBinding() {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return null;
        }
        return this.bindPos;
    }

    private boolean isValidBindingPos(class_2338 pos) {
        if (this.field_11863 == null || !this.field_11863.method_8477(pos)) {
            return false;
        }
        int maxDist = BotaniaOPConfig.pylonPumpMaxRange();
        if (MathHelper.distSqr((class_2382)this.field_11867, (class_2382)pos) > (long)(maxDist * maxDist)) {
            return false;
        }
        return this.getBoundTargetAt(pos) != null;
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10573("pos", 10)) {
            this.bindPos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
        }
    }

    protected void method_11007(class_2487 tag) {
        if (this.bindPos != null) {
            tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)this.bindPos));
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 res = new class_2487();
        this.method_11007(res);
        return res;
    }

    private ManaReceiver getBoundTargetAt(class_2338 target) {
        if (target == null || this.field_11863 == null) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(target);
        if (!(be instanceof ManaReceiver)) {
            return null;
        }
        ManaReceiver pool = (ManaReceiver)be;
        return pool;
    }

    @Override
    public ManaReceiver getBoundTarget() {
        return this.getBoundTargetAt(this.bindPos);
    }

    @Override
    public ManaReceiver getSource() {
        ManaReceiver target;
        if (this.field_11863 == null) {
            return null;
        }
        if (this.cachedPos == null || this.ticks % 20 == 0) {
            class_2338.class_2339 ptr = this.field_11867.method_10074().method_25503();
            int py = ptr.method_10264();
            while (this.field_11863.method_24794((class_2338)ptr)) {
                class_2586 be = this.field_11863.method_8321((class_2338)ptr);
                if (be instanceof ManaReceiver) {
                    ManaReceiver target2 = (ManaReceiver)be;
                    this.cachedPos = ptr.method_10062();
                    return target2;
                }
                if (!(be instanceof PylonBlockEntity)) break;
                ptr.method_33098(--py);
            }
            this.cachedPos = this.field_11867;
            return null;
        }
        class_2586 be = this.field_11863.method_8321(this.cachedPos);
        return be instanceof ManaReceiver ? (target = (ManaReceiver)be) : null;
    }

    @Override
    public class_243 getBoundCenter() {
        return class_243.method_24953((class_2382)this.bindPos);
    }

    @Inject(method={"commonTick"}, at={@At(value="RETURN")}, remap=false)
    private static void tickPump(class_1937 level, class_2338 worldPosition, class_2680 state, PylonBlockEntity self, CallbackInfo ci) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return;
        }
        ManaReceiver srcPool = ((PylonPumpExt)self).getSource();
        if (srcPool == null) {
            return;
        }
        ManaReceiver targetPool = ((PylonPumpExt)self).getBoundTarget();
        if (targetPool == null || targetPool.isFull()) {
            return;
        }
        int extractAmount = BotaniaOPConfig.pylonPumpSpeed();
        int reachedAmount = (int)Math.round((double)(extractAmount = Math.min(extractAmount, srcPool.getCurrentMana())) * (1.0 - BotaniaOPConfig.pylonPumpLossRatio()));
        if (reachedAmount <= 0) {
            return;
        }
        int oldMana = targetPool.getCurrentMana();
        targetPool.receiveMana(reachedAmount);
        int reachedReal = targetPool.getCurrentMana() - oldMana;
        if (reachedReal != reachedAmount) {
            extractAmount = (int)Math.ceil((float)extractAmount * (float)reachedReal / (float)reachedAmount);
        }
        srcPool.receiveMana(-extractAmount);
        if (level.field_9236 && extractAmount > 0 && BotaniaOPConfig.enablesPylonPumpFx()) {
            PylonBlock.Variant variant = ((PylonBlock)state.method_26204()).variant;
            class_243 start = class_243.method_24953((class_2382)worldPosition);
            class_243 end = ((PylonPumpExt)self).getBoundCenter();
            class_243 dir = end.method_1020(start).method_1029().method_1021(0.5);
            start = start.method_1019(dir);
            end = end.method_1020(dir);
            for (int i = 0; i < BotaniaOPConfig.pylonPumpFxStrength(); ++i) {
                WispParticleData particle = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)variant.r, (float)variant.g, (float)variant.b, (float)0.5f).withNoClip(true);
                double mid = Math.random();
                double speed = Math.random() * 0.2;
                level.method_8406((class_2394)particle, class_3532.method_16436((double)mid, (double)start.field_1352, (double)end.field_1352), class_3532.method_16436((double)mid, (double)start.field_1351, (double)end.field_1351), class_3532.method_16436((double)mid, (double)start.field_1350, (double)end.field_1350), speed * dir.field_1352, speed * dir.field_1351, speed * dir.field_1350);
            }
        }
    }
}

