/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin;

import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.api.DandelifeonRules;
import io.yukkuric.botania_overpowered.helpers.ReflectionHelpers;
import java.util.ArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity;

@Mixin(value={DandelifeonBlockEntity.class})
public abstract class MixinDandelifeon
extends GeneratingFlowerBlockEntity {
    @Shadow(remap=false)
    private int radius;
    private static final String CLASSNAME_TABLE = "vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable";
    private static ReflectionHelpers.WrappedCtor<ITable> TABLE = new ReflectionHelpers.WrappedCtor<ITable>(ITable.class, "vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable", Integer.TYPE, DandelifeonBlockEntity.class);

    @Shadow(remap=false)
    abstract void setBlockForGeneration(class_2338 var1, int var2, int var3);

    public MixinDandelifeon(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"runSimulation"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void replaceSimulation(CallbackInfo ci) {
        ci.cancel();
        try {
            this.replaceSimulationInner();
        }
        catch (Throwable e) {
            this.radius = -1;
            MinecraftServer server = this.field_11863.method_8503();
            class_5250 stackComp = class_2561.method_43469((String)"bot_op.error.dandelifeon", (Object[])new Object[]{this.method_11016(), e.toString()});
            for (class_3222 p : server.method_3760().method_14571()) {
                p.method_43496((class_2561)stackComp);
            }
        }
    }

    private void replaceSimulationInner() {
        if (this.radius <= 0) {
            return;
        }
        ITable table = TABLE.get(new Object[]{this.radius, this});
        ArrayList<DandelifeonRules.LifeUpdate> changes = new ArrayList<DandelifeonRules.LifeUpdate>();
        int diameter = table.getDiameter();
        int allowDist = 1;
        boolean wipe = false;
        for (int i = 0; i < diameter; ++i) {
            boolean xInRange = Math.abs(i - this.radius) <= allowDist;
            for (int j = 0; j < diameter; ++j) {
                int oldLife = table.curStage(i, j);
                int adj = table.countScore(i, j);
                int newLife = oldLife == -1 && DandelifeonRules.CheckRuleNew(adj) ? table.nextStage(i, j) : (DandelifeonBlockEntity.Cell.isLive((int)oldLife) && DandelifeonRules.CheckRuleKeep(adj) ? oldLife + 1 : -1);
                if (xInRange && Math.abs(j - this.radius) <= allowDist && DandelifeonBlockEntity.Cell.isLive((int)newLife)) {
                    if (oldLife == 1) {
                        newLife = -1;
                    } else {
                        oldLife = newLife;
                        newLife = -2;
                        wipe = true;
                    }
                }
                if (newLife == oldLife) continue;
                changes.add(new DandelifeonRules.LifeUpdate(i, j, newLife, oldLife));
            }
        }
        if (wipe && BotaniaOPConfig.skipDandelifeonClearBoard()) {
            wipe = false;
        }
        for (DandelifeonRules.LifeUpdate change : changes) {
            class_2338 pos_ = table.getCenter().method_10069(-this.radius + change.x(), 0, -this.radius + change.z());
            int newLife = change.newLife();
            if (wipe) {
                newLife = -1;
            }
            this.setBlockForGeneration(pos_, Math.min(newLife, 100), change.oldLife());
        }
    }

    @Mixin(targets={"vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity$CellTable"})
    public static interface ITable {
        @Accessor(value="center", remap=false)
        public class_2338 getCenter();

        @Accessor(value="diameter", remap=false)
        public int getDiameter();

        @Invoker(value="getAdjCells", remap=false)
        public int countScore(int var1, int var2);

        @Invoker(value="getSpawnCellGeneration", remap=false)
        public int nextStage(int var1, int var2);

        @Invoker(value="at", remap=false)
        public int curStage(int var1, int var2);
    }
}

