/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.botania_overpowered.mixin;

import io.yukkuric.botania_overpowered.BotaniaOPConfig;
import io.yukkuric.botania_overpowered.mixin_interface.PylonPumpExt;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.api.block.WandBindable;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.helper.MathHelper;

@Mixin(value={PylonBlockEntity.class})
public class MixinPylonPump
extends class_2586
implements WandBindable,
PylonPumpExt {
    private class_2338 bindPos = null;

    public MixinPylonPump(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public boolean canSelect(class_1657 player, class_1799 itemStack, class_2338 blockPos, class_2350 direction) {
        return BotaniaOPConfig.enablesManaPylonPump();
    }

    public boolean bindTo(class_1657 foo, class_1799 bar, class_2338 newPos, class_2350 baz) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return false;
        }
        if (!this.isValidBindingPos(newPos)) {
            newPos = null;
        }
        if (!Objects.equals(newPos, this.bindPos)) {
            this.bindPos = newPos;
            this.method_5431();
        }
        return true;
    }

    @Nullable
    public class_2338 getBinding() {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return null;
        }
        return this.bindPos;
    }

    private boolean isValidBindingPos(class_2338 pos) {
        if (this.field_11863 == null || !this.field_11863.method_8477(pos)) {
            return false;
        }
        int maxDist = BotaniaOPConfig.pylonPumpMaxRange();
        if (MathHelper.distSqr((class_2382)this.field_11867, (class_2382)pos) > (long)(maxDist * maxDist)) {
            return false;
        }
        return this.getBoundTargetAt(pos) != null;
    }

    public void method_11014(class_2487 tag) {
        if (tag.method_10573("pos", 10)) {
            this.bindPos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
        }
    }

    protected void method_11007(class_2487 tag) {
        if (this.bindPos != null) {
            tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)this.bindPos));
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 res = new class_2487();
        this.method_11007(res);
        return res;
    }

    private ManaPool getBoundTargetAt(class_2338 target) {
        if (target == null || this.field_11863 == null) {
            return null;
        }
        class_2586 be = this.field_11863.method_8321(target);
        if (!(be instanceof ManaPool)) {
            return null;
        }
        ManaPool pool = (ManaPool)be;
        return pool;
    }

    @Override
    public ManaPool getBoundTarget() {
        return this.getBoundTargetAt(this.bindPos);
    }

    @Override
    public class_243 getBoundCenter() {
        return class_243.method_24953((class_2382)this.bindPos);
    }

    @Inject(method={"commonTick"}, at={@At(value="RETURN")}, remap=false)
    private static void tickPump(class_1937 level, class_2338 worldPosition, class_2680 state, PylonBlockEntity self, CallbackInfo ci) {
        if (!BotaniaOPConfig.enablesManaPylonPump()) {
            return;
        }
        class_2586 srcBE = level.method_8321(worldPosition.method_10074());
        if (!(srcBE instanceof ManaPool)) {
            return;
        }
        ManaPool srcPool = (ManaPool)srcBE;
        ManaPool targetPool = ((PylonPumpExt)self).getBoundTarget();
        if (targetPool == null) {
            return;
        }
        int extractAmount = BotaniaOPConfig.pylonPumpSpeed();
        extractAmount = Math.min(extractAmount, srcPool.getCurrentMana());
        extractAmount = Math.min(extractAmount, targetPool.getMaxMana() - targetPool.getCurrentMana());
        int reachedAmount = (int)Math.round((double)extractAmount * (1.0 - BotaniaOPConfig.pylonPumpLossRatio()));
        srcPool.receiveMana(-extractAmount);
        targetPool.receiveMana(reachedAmount);
        if (level.field_9236 && extractAmount > 0 && BotaniaOPConfig.enablesPylonPumpFx()) {
            PylonBlock.Variant variant = ((PylonBlock)state.method_26204()).variant;
            class_243 start = class_243.method_24953((class_2382)worldPosition);
            class_243 end = ((PylonPumpExt)self).getBoundCenter();
            class_243 dir = end.method_1020(start).method_1029().method_1021(0.5);
            start = start.method_1019(dir);
            end = end.method_1020(dir);
            for (int i = 0; i < BotaniaOPConfig.pylonPumpFxStrength(); ++i) {
                WispParticleData particle = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)variant.r, (float)variant.g, (float)variant.b, (float)0.5f).withNoClip(true);
                double mid = Math.random();
                double speed = Math.random() * 0.2;
                level.method_8406((class_2394)particle, class_3532.method_16436((double)mid, (double)start.field_1352, (double)end.field_1352), class_3532.method_16436((double)mid, (double)start.field_1351, (double)end.field_1351), class_3532.method_16436((double)mid, (double)start.field_1350, (double)end.field_1350), speed * dir.field_1352, speed * dir.field_1351, speed * dir.field_1350);
            }
        }
    }
}

