/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.cursedcompass.client.property;

import com.mrbysco.cursedcompass.registry.CursedRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursedCompassAngleProperty
implements ItemPropertyFunction {
    private double rotation;
    private double rota;
    private long lastUpdateTick;

    public float call(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingBaseIn, int seed) {
        double d0;
        BlockPos targetPos;
        LivingEntity entity;
        if (livingBaseIn == null && !stack.isFramed()) {
            return 0.0f;
        }
        boolean livingExists = livingBaseIn != null;
        Object object = entity = livingExists ? livingBaseIn : stack.getFrame();
        if (clientLevel == null && entity.level() instanceof ClientLevel) {
            clientLevel = (ClientLevel)entity.level();
        }
        if ((targetPos = this.getTargetPos(stack)) != null) {
            double d1 = livingExists ? (double)entity.getYRot() : this.getFrameRotation((ItemFrame)entity);
            d1 = Mth.positiveModulo((double)(d1 / 360.0), (double)1.0);
            double d2 = this.getSpawnToAngle((Entity)entity, targetPos) / 6.2831854820251465;
            d0 = 0.5 - (d1 - 0.25 - d2);
        } else {
            d0 = Math.random();
        }
        if (livingExists) {
            d0 = this.wobble(clientLevel, d0);
        }
        return Mth.positiveModulo((float)((float)d0), (float)1.0f);
    }

    private double wobble(ClientLevel clientLevel, double p_185093_2_) {
        if (clientLevel.getGameTime() != this.lastUpdateTick) {
            this.lastUpdateTick = clientLevel.getGameTime();
            double d0 = p_185093_2_ - this.rotation;
            d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }

    private double getFrameRotation(ItemFrame itemFrame) {
        Direction direction = itemFrame.getDirection();
        int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + itemFrame.getRotation() * 45 + i));
    }

    private double getSpawnToAngle(Entity entityIn, @NotNull BlockPos pos) {
        return Math.atan2((double)pos.getZ() - entityIn.getZ(), (double)pos.getX() - entityIn.getX());
    }

    @Nullable
    public BlockPos getTargetPos(ItemStack stack) {
        if (stack.has(CursedRegistry.TARGET_POS)) {
            return (BlockPos)stack.get(CursedRegistry.TARGET_POS);
        }
        return null;
    }
}

