/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.cursedcompass.item;

import com.mrbysco.cursedcompass.CursedCompass;
import com.mrbysco.cursedcompass.registry.CursedRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CursedCompassItem
extends Item {
    public CursedCompassItem(Item.Properties properties) {
        super(properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!stack.has(CursedRegistry.TARGET_ID)) {
                Iterable entityIterable = serverLevel.getEntities().getAll();
                ArrayList<Object> entityList = new ArrayList();
                entityIterable.forEach(entityList::add);
                if (entityList.isEmpty()) {
                    return;
                }
                if (!(entityList = new ArrayList<Entity>(entityList.stream().filter(foundEntity -> foundEntity instanceof LivingEntity && foundEntity.getType().is(CursedCompass.TARGETS) && foundEntity.distanceTo(entity) < 100.0f).toList())).isEmpty()) {
                    Collections.shuffle(entityList);
                    Entity targetEntity = (Entity)entityList.getFirst();
                    stack.set(CursedRegistry.TARGET_ID, (Object)targetEntity.getUUID());
                    stack.set(CursedRegistry.TARGET_POS, (Object)targetEntity.blockPosition());
                }
            } else {
                UUID targetID = (UUID)stack.get(CursedRegistry.TARGET_ID);
                assert (targetID != null);
                Entity targetEntity = serverLevel.getEntity(targetID);
                if (targetEntity == null || !targetEntity.isAlive()) {
                    stack.remove(CursedRegistry.TARGET_ID);
                    stack.remove(CursedRegistry.TARGET_POS);
                } else if (level.dimension().equals(targetEntity.level().dimension())) {
                    stack.set(CursedRegistry.TARGET_POS, (Object)targetEntity.blockPosition());
                } else {
                    stack.remove(CursedRegistry.TARGET_ID);
                    stack.remove(CursedRegistry.TARGET_POS);
                }
            }
        }
    }
}

