/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.cursedcompass.loot;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.cursedcompass.registry.CursedRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class CursedLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<CursedLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> CursedLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CursedLootModifier::new)));

    public CursedLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.getRandom();
        if (random.nextInt(4) == 0) {
            generatedLoot.add((Object)CursedRegistry.CURSED_COMPASS.toStack());
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CursedRegistry.CURSED_LOOT.get();
    }
}

