/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BuiltinJson {
    private BuiltinJson() {
    }

    public static Result<ResourceLocation, Problem> parseIdentifier(JsonElement element) {
        return BuiltinJson.parseFromString(element, ResourceLocation::new, "identifier");
    }

    public static Result<String, Problem> parseIdentifierPath(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> new ResourceLocation("minecraft", s).m_135815_(), "identifier path");
    }

    public static Result<MobEffect, Problem> parseEffect(JsonElement element) {
        return BuiltinJson.parseSomething(element, Registry.f_122823_, "effect");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, Registry.f_122823_, "effect");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectOrEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, Registry.f_122823_, "effect");
    }

    public static Result<Block, Problem> parseBlock(JsonElement element) {
        return BuiltinJson.parseSomething(element, Registry.f_122824_, "block");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, Registry.f_122824_, "block");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockOrBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, Registry.f_122824_, "block");
    }

    public static Result<EntityType<?>, Problem> parseEntityType(JsonElement element) {
        return BuiltinJson.parseSomething(element, Registry.f_122826_, "entity type");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, Registry.f_122826_, "entity type");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeOrEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, Registry.f_122826_, "entity type");
    }

    public static Result<Item, Problem> parseItem(JsonElement element) {
        return BuiltinJson.parseSomething(element, Registry.f_122827_, "item");
    }

    public static Result<HolderSet<Item>, Problem> parseItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, Registry.f_122827_, "item");
    }

    public static Result<HolderSet<Item>, Problem> parseItemOrItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, Registry.f_122827_, "item");
    }

    public static Result<StatType<?>, Problem> parseStatType(JsonElement element) {
        return BuiltinJson.parseSomething(element, Registry.f_122867_, "stat type");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, Registry.f_122867_, "stat type");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeOrStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, Registry.f_122867_, "stat type");
    }

    public static Result<StatePropertiesPredicate, Problem> parseStatePredicate(JsonElement element) {
        try {
            return Result.success(StatePropertiesPredicate.m_67679_((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected state predicate"));
        }
    }

    public static Result<NbtPredicate, Problem> parseNbtPredicate(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return new NbtPredicate(TagParser.m_129359_((String)s));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "nbt predicate");
    }

    public static Result<Stat<?>, Problem> parseStat(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> BuiltinJson.getOrCreateStat((StatType)Registry.f_122867_.m_6612_(ResourceLocation.m_135822_((String)id.m_135827_(), (char)'.')).orElseThrow(), ResourceLocation.m_135822_((String)id.m_135815_(), (char)'.')), "stat");
    }

    private static <T> Stat<T> getOrCreateStat(StatType<T> statType, ResourceLocation id) {
        return statType.m_12902_(statType.m_12893_().m_6612_(id).orElseThrow());
    }

    public static Result<CompoundTag, Problem> parseNbt(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return TagParser.m_129359_((String)s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "nbt");
    }

    public static Result<ItemStack, Problem> parseItemStack(JsonElement element) {
        try {
            return element.getAsObject().andThen(rootObject -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                Optional item = rootObject.get("item").andThen(BuiltinJson::parseItem).ifFailure(problems::add).getSuccess();
                Optional nbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbt(nbtElement).ifFailure(problems::add).getSuccess());
                if (problems.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Problem.combine(problems));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected item stack"));
        }
    }

    public static Result<FrameType, Problem> parseFrame(JsonElement element) {
        try {
            return element.getAsString().andThen(name -> Result.success(FrameType.m_15549_((String)name)));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected frame"));
        }
    }

    public static Result<Component, Problem> parseText(JsonElement element) {
        try {
            return Result.success(Component.Serializer.m_130691_((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected text"));
        }
    }

    public static Result<Attribute, Problem> parseAttribute(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> {
            if (id.m_135827_().equals("puffish_skills")) {
                id = new ResourceLocation("puffish_attributes", id.m_135815_());
            }
            return (Attribute)Registry.f_122866_.m_6612_(id).orElseThrow();
        }, "attribute");
    }

    public static Result<AttributeModifier.Operation, Problem> parseAttributeOperation(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> switch (s) {
            case "add", "add_value", "addition" -> AttributeModifier.Operation.ADDITION;
            case "multiply_base", "add_multiplied_base" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "multiply_total", "add_multiplied_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> throw new RuntimeException();
        }, "attribute operation");
    }

    private static <T> Result<T, Problem> parseFromString(JsonElement element, Function<String, T> parser, String what) {
        try {
            String s = element.getJson().getAsString();
            try {
                return Result.success(parser.apply(s));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Invalid " + what + " `" + s + "`"));
            }
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem("Expected " + what));
        }
    }

    private static <T> Result<T, Problem> parseFromIdentifier(JsonElement element, Function<ResourceLocation, T> parser, String what) {
        return BuiltinJson.parseFromString(element, ResourceLocation::new, what).andThen(id -> {
            try {
                return Result.success(parser.apply((ResourceLocation)id));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Unknown " + what + " `" + String.valueOf(id) + "`"));
            }
        });
    }

    private static <T> Result<T, Problem> parseSomething(JsonElement element, Registry<T> registry, String what) {
        return BuiltinJson.parseFromIdentifier(element, id -> registry.m_6612_(id).orElseThrow(), what);
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingTag(JsonElement element, Registry<T> registry, String what) {
        return BuiltinJson.parseFromString(element, s -> s.startsWith("#") ? new ResourceLocation(s.substring(1)) : new ResourceLocation(s), what).andThen(id -> {
            try {
                return Result.success((HolderSet)registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id)).orElseThrow());
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Unknown " + what + " tag `" + String.valueOf(id) + "`"));
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static <T> Result<HolderSet<T>, Problem> parseSomethingOrSomethingTag(JsonElement element, Registry<T> registry, String what) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

