/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_361;
import net.minecraft.class_437;
import net.minecraft.class_455;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_8030;
import net.minecraft.class_8658;
import net.minecraft.class_8666;
import net.minecraft.class_8690;
import net.minecraft.class_9848;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillScreenData;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.client.rendering.ConnectionBatchedRenderer;
import net.puffish.skillsmod.client.rendering.ItemBatchedRenderer;
import net.puffish.skillsmod.client.rendering.TextureBatchedRenderer;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.util.Bounds2i;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2i;

public class SkillsScreen
extends class_437 {
    private static final class_2960 WINDOW_TEXTURE = class_2960.method_60654((String)"textures/gui/advancements/window.png");
    private static final class_2960 EXPERIENCE_BAR_BACKGROUND_TEXTURE = class_2960.method_60654((String)"hud/experience_bar_background");
    private static final class_2960 EXPERIENCE_BAR_PROGRESS_TEXTURE = class_2960.method_60654((String)"hud/experience_bar_progress");
    private static final class_2960 TAB_ABOVE_LEFT_SELECTED_TEXTURE = class_2960.method_60654((String)"advancements/tab_above_left_selected");
    private static final class_2960 TAB_ABOVE_MIDDLE_SELECTED_TEXTURE = class_2960.method_60654((String)"advancements/tab_above_middle_selected");
    private static final class_2960 TAB_ABOVE_LEFT_TEXTURE = class_2960.method_60654((String)"advancements/tab_above_left");
    private static final class_2960 TAB_ABOVE_MIDDLE_TEXTURE = class_2960.method_60654((String)"advancements/tab_above_middle");
    private static final class_8666 PAGE_FORWARD_TEXTURES = new class_8666(class_2960.method_60656((String)"recipe_book/page_forward"), class_2960.method_60656((String)"recipe_book/page_forward_highlighted"));
    private static final class_8666 PAGE_BACKWARD_TEXTURES = new class_8666(class_2960.method_60656((String)"recipe_book/page_backward"), class_2960.method_60656((String)"recipe_book/page_backward_highlighted"));
    private static final class_2960 TRIAL_AVAILABLE_TEXTURE = class_2960.method_60654((String)"icon/trial_available");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private static final int COLOR_WHITE = class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    private static final int COLOR_GRAY = class_9848.method_61318((float)1.0f, (float)0.25f, (float)0.25f, (float)0.25f);
    private final ClientSkillScreenData data;
    private Optional<ClientCategoryData> optActiveCategoryData = Optional.empty();
    private Optional<class_2960> optActiveCategoryId;
    private class_361 nextButton;
    private class_361 prevButton;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private double dragTotal = 0.0;
    private boolean canDrag = false;
    private Bounds2i bounds = Bounds2i.zero();
    private boolean small = false;
    private int contentPaddingTop = 0;
    private int contentPaddingLeft = 0;
    private int contentPaddingRight = 0;
    private int contentPaddingBottom = 0;

    public SkillsScreen(ClientSkillScreenData data, Optional<class_2960> optCategoryId) {
        super(class_5244.field_39003);
        this.data = data;
        this.optActiveCategoryId = optCategoryId;
    }

    protected void method_25426() {
        super.method_25426();
        this.resize();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.resize();
    }

    private void resize() {
        this.small = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.hasExperience() && this.field_22789 < 450).orElse(false);
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        int halfWidth = this.field_22789 / 2;
        int halfHeight = this.field_22790 / 2;
        this.bounds = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.getConfig().getBounds()).orElseGet(Bounds2i::zero);
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - halfWidth, this.contentPaddingTop - halfHeight));
        this.bounds.extend(new Vector2i(this.field_22789 - halfWidth - this.contentPaddingRight, this.field_22790 - halfHeight - this.contentPaddingBottom));
        int contentWidth = this.field_22789 - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.field_22790 - this.contentPaddingTop - this.contentPaddingBottom;
        if (this.bounds.width() * contentHeight > contentWidth * this.bounds.height()) {
            int halfSize = class_3532.method_38788((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
            this.bounds.extendY(-halfSize);
            this.bounds.extendY(halfSize);
        } else {
            int halfSize = class_3532.method_38788((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
            this.bounds.extendX(-halfSize);
            this.bounds.extendX(halfSize);
        }
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits(activeCategoryData.getX(), activeCategoryData.getY(), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
        this.nextButton = new class_361(this.field_22789 - 8 - 12, 16, 12, 17, false){

            public void method_25348(double mouseX, double mouseY) {
                SkillsScreen.this.data.incrementOffset();
            }
        };
        this.nextButton.method_1962(PAGE_FORWARD_TEXTURES);
        this.prevButton = new class_361(8, 16, 12, 17, true){

            public void method_25348(double mouseX, double mouseY) {
                SkillsScreen.this.data.decrementOffset();
            }
        };
        this.prevButton.method_1962(PAGE_BACKWARD_TEXTURES);
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        return new Vector2i((int)Math.round((mouseX - (double)activeCategoryData.getX() - (double)this.field_22789 / 2.0) / (double)activeCategoryData.getScale()), (int)Math.round((mouseY - (double)activeCategoryData.getY() - (double)this.field_22790 / 2.0) / (double)activeCategoryData.getScale()));
    }

    private boolean isInsideTab(Vector2i mouse, int x) {
        return mouse.x >= x && mouse.y >= 8 && mouse.x < x + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillConfig skill, ClientSkillDefinitionConfig definition) {
        int halfSize = Math.round(13.0f * definition.size());
        return transformedMouse.x >= skill.x() - halfSize && transformedMouse.y >= skill.y() - halfSize && transformedMouse.x < skill.x() + halfSize && transformedMouse.y < skill.y() + halfSize;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.field_22789 - this.contentPaddingRight && mouse.y < this.field_22790 - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vector2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vector2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    private void syncCategory() {
        Optional opt = this.optActiveCategoryId.flatMap(this.data::getCategory);
        opt.ifPresent(ClientCategoryData::updateLastOpen);
        if (this.optActiveCategoryData.isEmpty() || this.optActiveCategoryData.orElseThrow() != opt.orElse(null)) {
            this.optActiveCategoryData = this.data.getCategories().stream().max(Comparator.comparing(ClientCategoryData::getLastOpen));
            this.optActiveCategoryId = this.optActiveCategoryData.map(data -> data.getConfig().id());
            this.resize();
        }
        this.optActiveCategoryData.ifPresent(ClientCategoryData::updateUnseenPoints);
    }

    private int getTabX(int i) {
        return 8 + (i - this.data.getOffset()) * 32 + (this.data.getOffset() > 0 ? 15 : 0);
    }

    private void forEachVisibleTab(BiConsumer<Integer, ClientCategoryData> consumer) {
        Iterator<ClientCategoryData> it = this.data.getCategories().iterator();
        int i = 0;
        while (it.hasNext()) {
            ClientCategoryData category = it.next();
            int x = this.getTabX(i);
            if (x >= 8 && x + 28 <= this.field_22789 - 8 - 12 - 3) {
                consumer.accept(x, category);
            }
            ++i;
        }
    }

    private boolean hasNextButton() {
        int x = this.getTabX(this.data.getCategories().size() - 1);
        return x + 28 > this.field_22789 - 8 - 12 - 3;
    }

    private boolean hasPrevButton() {
        return this.data.getOffset() > 0;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseClickedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        if (this.hasNextButton()) {
            this.nextButton.method_25402(mouseX, mouseY, button);
        }
        if (this.hasPrevButton()) {
            this.prevButton.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    private void mouseClickedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            this.dragStartX = mouseX - (double)activeCategoryData.getX();
            this.dragStartY = mouseY - (double)activeCategoryData.getY();
            this.dragTotal = 0.0;
            this.canDrag = true;
        } else {
            this.canDrag = false;
        }
        this.forEachVisibleTab((x, category) -> {
            if (this.isInsideTab(mouse, (int)x)) {
                this.optActiveCategoryId = Optional.ofNullable(category.getConfig().id());
                this.syncCategory();
            }
        });
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.dragTotal > 2.0) {
                return true;
            }
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseReleasedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        return true;
    }

    private void mouseReleasedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        if (this.isInsideContent(mouse)) {
            for (ClientSkillConfig skill : activeCategory.skills().values()) {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(skill.definitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(new SkillClickOutPacket(activeCategory.id(), skill.id()));
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.syncCategory();
        this.drawContent(context, mouseX, mouseY);
        this.drawWindow(context, mouseX, mouseY);
        this.drawTabs(context, mouseX, mouseY, delta);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.canDrag) {
            return true;
        }
        if (button == 0) {
            this.dragTotal += Math.abs(deltaX);
            this.dragTotal += Math.abs(deltaY);
            if (this.dragTotal > 2.0) {
                this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits((int)Math.round(mouseX - this.dragStartX), (int)Math.round(mouseY - this.dragStartY), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
            }
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.optActiveCategoryData.ifPresent(activeCategoryData -> {
            float factor = (float)Math.pow(2.0, verticalAmount * 0.25);
            int x = activeCategoryData.getX();
            int y = activeCategoryData.getY();
            float scale = activeCategoryData.getScale();
            if ((scale *= factor) < this.minScale) {
                scale = this.minScale;
                factor = this.minScale / scale;
            }
            if (scale > this.maxScale) {
                scale = this.maxScale;
                factor = this.maxScale / scale;
            }
            this.applyChangesWithLimits(x - (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)x - (double)((float)this.field_22789 / 2.0f))), y - (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)y - (double)((float)this.field_22790 / 2.0f))), scale, (ClientCategoryData)activeCategoryData);
        });
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void applyChangesWithLimits(int x, int y, float scale, ClientCategoryData activeCategoryData) {
        int halfWidth = this.field_22789 / 2;
        int halfHeight = this.field_22790 / 2;
        scale = class_3532.method_15363((float)scale, (float)this.minScale, (float)this.maxScale);
        activeCategoryData.setX(class_3532.method_15340((int)x, (int)((int)Math.ceil((float)(halfWidth - this.contentPaddingRight) - (float)this.bounds.max().x() * scale)), (int)((int)Math.floor((float)(this.contentPaddingLeft - halfWidth) - (float)this.bounds.min().x() * scale))));
        activeCategoryData.setY(class_3532.method_15340((int)y, (int)((int)Math.ceil((float)(halfHeight - this.contentPaddingBottom) - (float)this.bounds.max().y() * scale)), (int)((int)Math.floor((float)(this.contentPaddingTop - halfHeight) - (float)this.bounds.min().y() * scale))));
        activeCategoryData.setScale(scale);
    }

    private void drawIcon(class_332 context, TextureBatchedRenderer textureRenderer, ItemBatchedRenderer itemRenderer, ClientIconConfig icon, float sizeScale, int x, int y) {
        if (this.field_22787 == null) {
            return;
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        if (icon instanceof ClientIconConfig.ItemIconConfig) {
            ClientIconConfig.ItemIconConfig itemIcon = (ClientIconConfig.ItemIconConfig)icon;
            matrices.translate((float)x * (1.0f - sizeScale), (float)y * (1.0f - sizeScale));
            matrices.scale(sizeScale, sizeScale);
            itemRenderer.emitItem(context, itemIcon.item(), x, y);
        } else if (icon instanceof ClientIconConfig.EffectIconConfig) {
            ClientIconConfig.EffectIconConfig effectIcon = (ClientIconConfig.EffectIconConfig)icon;
            class_8658 guiAtlasManager = this.field_22787.method_52699();
            class_2960 texture = class_329.method_71644((class_6880)class_7923.field_41174.method_47983((Object)effectIcon.effect()));
            class_1058 sprite = guiAtlasManager.method_18667(texture);
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitSprite(context, sprite, class_8690.field_45649, x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        } else if (icon instanceof ClientIconConfig.TextureIconConfig) {
            ClientIconConfig.TextureIconConfig textureIcon = (ClientIconConfig.TextureIconConfig)icon;
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitTexture(context, textureIcon.texture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        }
        matrices.popMatrix();
    }

    private void drawFrame(class_332 context, TextureBatchedRenderer textureRenderer, ClientFrameConfig frame, float sizeScale, int x, int y, Skill.State state) {
        if (this.field_22787 == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameConfig.AdvancementFrameConfig) {
            ClientFrameConfig.AdvancementFrameConfig advancementFrame = (ClientFrameConfig.AdvancementFrameConfig)frame;
            class_8658 guiAtlasManager = this.field_22787.method_52699();
            class_455 status = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case Skill.State.LOCKED, Skill.State.EXCLUDED, Skill.State.AVAILABLE, Skill.State.AFFORDABLE -> class_455.field_2699;
                case Skill.State.UNLOCKED -> class_455.field_2701;
            };
            class_2960 texture = status.method_52754(advancementFrame.frame());
            class_1058 sprite = guiAtlasManager.method_18667(texture);
            class_8690 scaling = guiAtlasManager.method_52714(sprite);
            int color = switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case Skill.State.LOCKED, Skill.State.EXCLUDED -> COLOR_GRAY;
                case Skill.State.AVAILABLE, Skill.State.AFFORDABLE, Skill.State.UNLOCKED -> COLOR_WHITE;
            };
            textureRenderer.emitSprite(context, sprite, scaling, x - halfSize, y - halfSize, size, size, color);
        } else if (frame instanceof ClientFrameConfig.TextureFrameConfig) {
            ClientFrameConfig.TextureFrameConfig textureFrame = (ClientFrameConfig.TextureFrameConfig)frame;
            switch (state) {
                case LOCKED: {
                    textureFrame.lockedTexture().ifPresentOrElse(lockedTexture -> textureRenderer.emitTexture(context, (class_2960)lockedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                case AVAILABLE: {
                    textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case AFFORDABLE: {
                    textureFrame.affordableTexture().ifPresentOrElse(affordableTexture -> textureRenderer.emitTexture(context, (class_2960)affordableTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE));
                    break;
                }
                case UNLOCKED: {
                    textureRenderer.emitTexture(context, textureFrame.unlockedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case EXCLUDED: {
                    textureFrame.excludedTexture().ifPresentOrElse(excludedTexture -> textureRenderer.emitTexture(context, (class_2960)excludedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void drawBackground(class_332 context, ClientBackgroundConfig background) {
        int y;
        int x;
        int height;
        int width;
        BackgroundPosition position = background.position();
        switch (position) {
            case TILE: {
                context.method_25290(class_10799.field_56883, background.texture(), this.bounds.min().x(), this.bounds.min().y(), 0.0f, 0.0f, this.bounds.width(), this.bounds.height(), background.width(), background.height());
                return;
            }
            case FILL: {
                if (this.bounds.width() * background.height() > background.width() * this.bounds.height()) {
                    position = BackgroundPosition.FILL_WIDTH;
                    break;
                }
                position = BackgroundPosition.FILL_HEIGHT;
                break;
            }
        }
        switch (position) {
            case NONE: {
                width = background.width();
                height = background.height();
                x = width / -2;
                y = height / -2;
                break;
            }
            case FILL_WIDTH: {
                x = this.bounds.min().x();
                width = this.bounds.width();
                y = this.bounds.min().y() + this.bounds.height() / 2 - class_3532.method_38788((int)(background.height() * width), (int)(2 * background.width()));
                height = class_3532.method_38788((int)(background.height() * width), (int)background.width());
                break;
            }
            case FILL_HEIGHT: {
                y = this.bounds.min().y();
                height = this.bounds.height();
                x = this.bounds.min().x() + this.bounds.width() / 2 - class_3532.method_38788((int)(background.width() * height), (int)(2 * background.height()));
                width = class_3532.method_38788((int)(background.width() * height), (int)background.height());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        context.method_25290(class_10799.field_56883, background.texture(), x, y, 0.0f, 0.0f, width, height, width, height);
    }

    private void drawContent(class_332 context, int mouseX, int mouseY) {
        int minX = this.contentPaddingLeft - 4;
        int minY = this.contentPaddingTop - 4;
        int maxX = this.field_22789 - this.contentPaddingRight + 4;
        int maxY = this.field_22790 - this.contentPaddingBottom + 4;
        class_8030 scissorArea = new class_8030(minX, minY, maxX - minX, maxY - minY).method_65185((Matrix3x2f)context.method_51448());
        context.method_44379(minX, minY, maxX, maxY);
        context.method_25294(0, 0, this.field_22789, this.field_22790, -16777216);
        this.optActiveCategoryData.ifPresentOrElse(activeCategoryData -> this.drawContentWithCategory(context, mouseX, mouseY, scissorArea, (ClientCategoryData)activeCategoryData), () -> this.drawContentWithoutCategory(context));
        context.method_44380();
    }

    private void drawContentWithCategory(class_332 context, int mouseX, int mouseY, class_8030 scissorArea, ClientCategoryData activeCategoryData) {
        if (this.field_22787 == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)activeCategoryData.getX() + (float)this.field_22789 / 2.0f, (float)activeCategoryData.getY() + (float)this.field_22790 / 2.0f);
        matrices.scale(activeCategoryData.getScale(), activeCategoryData.getScale());
        this.drawBackground(context, activeCategory.background());
        ConnectionBatchedRenderer connectionRenderer = new ConnectionBatchedRenderer();
        for (ClientSkillConnectionConfig clientSkillConnectionConfig : activeCategory.normalConnections()) {
            activeCategoryData.getConnection(clientSkillConnectionConfig).ifPresent(relation -> connectionRenderer.emitConnection(context, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), clientSkillConnectionConfig.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillConfig> optHoveredSkill = activeCategory.skills().values().stream().filter(skill -> activeCategory.getDefinitionById(skill.definitionId()).map(definition -> this.isInsideSkill(transformedMouse, (ClientSkillConfig)skill, (ClientSkillDefinitionConfig)definition)).orElse(false)).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(hoveredSkill.definitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<class_5481> lines = new ArrayList<class_5481>();
                lines.add(definition.title().method_30937());
                lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)definition.description().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                if (class_437.method_25442()) {
                    lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)definition.extraDescription().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                }
                if (this.field_22787.field_1690.field_1827) {
                    lines.add(class_2561.method_43470((String)hoveredSkill.id()).method_27692(class_124.field_1063).method_30937());
                }
                context.method_71274(lines, mouseX, mouseY);
                Collection<ClientSkillConnectionConfig> connections = activeCategory.skillExclusiveConnections().get(hoveredSkill.id());
                if (connections != null) {
                    for (ClientSkillConnectionConfig connection : connections) {
                        activeCategoryData.getConnection(connection).ifPresent(relation -> connectionRenderer.emitConnection(context, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), connection.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
                    }
                }
            });
        }
        connectionRenderer.draw(context, scissorArea);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        for (ClientSkillConfig skill2 : activeCategory.skills().values()) {
            activeCategory.getDefinitionById(skill2.definitionId()).ifPresent(definition -> this.drawFrame(context, textureRenderer, definition.frame(), definition.size(), skill2.x(), skill2.y(), activeCategoryData.getSkillState(skill2)));
        }
        textureRenderer.draw(context, this.field_22787.method_1531(), scissorArea);
        ItemBatchedRenderer itemBatchedRenderer = new ItemBatchedRenderer();
        for (ClientSkillConfig skill3 : activeCategory.skills().values()) {
            activeCategory.getDefinitionById(skill3.definitionId()).ifPresent(definition -> this.drawIcon(context, textureRenderer, itemRenderer, definition.icon(), definition.size(), skill3.x(), skill3.y()));
        }
        textureRenderer.draw(context, this.field_22787.method_1531(), scissorArea);
        itemBatchedRenderer.draw(context, scissorArea);
        matrices.popMatrix();
    }

    private void drawContentWithoutCategory(class_332 context) {
        int tmpX = this.contentPaddingLeft + (this.field_22789 - this.contentPaddingLeft - this.contentPaddingRight) / 2;
        class_5250 class_52502 = class_2561.method_43471((String)"advancements.sad_label");
        Objects.requireNonNull(this.field_22793);
        context.method_27534(this.field_22793, (class_2561)class_52502, tmpX, this.field_22790 - this.contentPaddingBottom - 9, -1);
        class_5250 class_52503 = class_2561.method_43471((String)"advancements.empty");
        Objects.requireNonNull(this.field_22793);
        context.method_27534(this.field_22793, (class_2561)class_52503, tmpX, this.contentPaddingTop + (this.field_22790 - this.contentPaddingTop - this.contentPaddingBottom - 9) / 2, -1);
    }

    private void drawTabs(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        if (this.hasNextButton()) {
            this.nextButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.hasPrevButton()) {
            this.prevButton.method_25394(context, mouseX, mouseY, delta);
        }
        this.forEachVisibleTab((x, category) -> context.method_52706(class_10799.field_56883, this.optActiveCategoryData.orElse(null) == category ? (x == 8 ? TAB_ABOVE_LEFT_SELECTED_TEXTURE : TAB_ABOVE_MIDDLE_SELECTED_TEXTURE) : (x == 8 ? TAB_ABOVE_LEFT_TEXTURE : TAB_ABOVE_MIDDLE_TEXTURE), x.intValue(), 8, 28, 32));
        context.method_71048();
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemRenderer = new ItemBatchedRenderer();
        this.forEachVisibleTab((x, category) -> {
            ClientCategoryConfig categoryConfig = category.getConfig();
            this.drawIcon(context, textureRenderer, itemRenderer, categoryConfig.icon(), 1.0f, x + 6 + 8, 25);
            if (this.isInsideTab(mouse, (int)x)) {
                ArrayList<class_5481> lines = new ArrayList<class_5481>();
                lines.add(categoryConfig.title().method_30937());
                lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)categoryConfig.description().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                if (class_437.method_25442()) {
                    lines.addAll(class_7919.method_47406((class_310)this.field_22787, (class_2561)class_2564.method_10889((class_5250)categoryConfig.extraDescription().method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1080))));
                }
                if (this.field_22787.field_1690.field_1827) {
                    lines.add(class_2561.method_43470((String)categoryConfig.id().toString()).method_27692(class_124.field_1063).method_30937());
                }
                context.method_71274(lines, mouseX, mouseY);
            }
        });
        class_8030 scissorArea = new class_8030(0, 0, this.field_22789, this.field_22790);
        textureRenderer.draw(context, this.field_22787.method_1531(), scissorArea);
        itemRenderer.draw(context, scissorArea);
        this.forEachVisibleTab((x, category) -> {
            if (category.hasUnseenPoints()) {
                context.method_52706(class_10799.field_56883, TRIAL_AVAILABLE_TEXTURE, x + 10, 3, 8, 8);
            }
        });
    }

    private void drawWindow(class_332 context, int mouseX, int mouseY) {
        if (this.field_22787 == null) {
            return;
        }
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, 8, this.field_22790 - 8 - 70, 0.0f, 70.0f, 126, 70, 256, 256);
        context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, this.field_22789 - 8 - 126, this.field_22790 - 8 - 70, 126.0f, 70.0f, 126, 70, 256, 256);
        context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, 8, 78, 0.0f, 69.0f, 126, this.field_22790 - 16 - 140, 126, 2, 256, 256);
        context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, 134, this.field_22790 - 8 - 70, 125.0f, 70.0f, this.field_22789 - 16 - 252, 70, 2, 70, 256, 256);
        context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, this.field_22789 - 8 - 126, 78, 126.0f, 69.0f, 126, this.field_22790 - 16 - 140, 126, 2, 256, 256);
        if (this.small) {
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 16, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, 8, 52, 0.0f, 8.0f, 126, 26, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, this.field_22789 - 8 - 126, 36, 126.0f, 0.0f, 126, 16, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, this.field_22789 - 8 - 126, 52, 126.0f, 8.0f, 126, 26, 256, 256);
            context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, 134, 36, 125.0f, 0.0f, this.field_22789 - 16 - 252, 16, 2, 16, 256, 256);
            context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, 134, 52, 125.0f, 8.0f, this.field_22789 - 16 - 252, 54, 2, 54, 256, 256);
        } else {
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 42, 256, 256);
            context.method_25290(class_10799.field_56883, WINDOW_TEXTURE, this.field_22789 - 8 - 126, 36, 126.0f, 0.0f, 126, 42, 256, 256);
            context.method_25302(class_10799.field_56883, WINDOW_TEXTURE, 134, 36, 125.0f, 0.0f, this.field_22789 - 16 - 252, 70, 2, 70, 256, 256);
        }
        class_5250 tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX, tmpY, -12566464, false);
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.drawWindowWithCategory(context, mouseX, mouseY, (ClientCategoryData)activeCategoryData));
    }

    private void drawWindowWithCategory(class_332 context, int mouseX, int mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        int tmpX = this.field_22789 - 8 - 7;
        int tmpY = 42;
        int startX = tmpX;
        class_5250 tmpText = class_2561.method_43470((String)(activeCategoryData.getPointsLeft() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategoryData.getSpentPointsLeft())));
        tmpX -= this.field_22793.method_27525((class_5348)tmpText);
        ClientFillStrokeColorsConfig pointsColor = activeCategory.colors().points();
        int pointsStrokeColor = pointsColor.stroke().argb();
        int pointsFillColor = pointsColor.fill().argb();
        context.method_51439(this.field_22793, (class_2561)tmpText, --tmpX - 1, tmpY, pointsStrokeColor, false);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX, tmpY - 1, pointsStrokeColor, false);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX + 1, tmpY, pointsStrokeColor, false);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX, tmpY + 1, pointsStrokeColor, false);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX, tmpY, pointsFillColor, false);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        context.method_51439(this.field_22793, (class_2561)tmpText, tmpX -= this.field_22793.method_27525((class_5348)tmpText), tmpY, -12566464, false);
        Objects.requireNonNull(this.field_22793);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<class_5481> lines = new ArrayList<class_5481>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategoryData.getEarnedPoints()).method_30937());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategoryData.getSpentPoints() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.spentPointsLimit())).method_30937());
            context.method_71274(lines, mouseX, mouseY);
        }
        if (activeCategoryData.hasExperience()) {
            if (this.small) {
                tmpX = this.field_22789 - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (this.field_22789 - 182) / 2;
                tmpY = 43;
            }
            context.method_52706(class_10799.field_56883, EXPERIENCE_BAR_BACKGROUND_TEXTURE, tmpX, tmpY, 182, 5);
            int width = Math.min(182, (int)(activeCategoryData.getExperienceProgress() * 183.0f));
            if (width > 0) {
                context.method_70846(class_10799.field_56883, EXPERIENCE_BAR_PROGRESS_TEXTURE, 182, 5, 0, 0, tmpX, tmpY, width, 5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<class_5481> lines = new ArrayList<class_5481>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategoryData.getCurrentLevel() + (String)(activeCategory.levelLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.levelLimit())).method_30937());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategoryData.getCurrentExperience(), activeCategoryData.getRequiredExperience(), class_3532.method_15375((float)(activeCategoryData.getExperienceProgress() * 100.0f))).method_30937());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategoryData.getExperienceToNextLevel()).method_30937());
                context.method_71274(lines, mouseX, mouseY);
            }
        }
    }
}

