/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2105;
import net.minecraft.class_6885;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class EntityCondition
implements Operation<class_1297, Boolean> {
    private final Optional<class_6885<class_1299<?>>> optEntityTypeEntries;
    private final Optional<class_2105> optNbt;

    private EntityCondition(Optional<class_6885<class_1299<?>>> optEntityTypeEntries, Optional<class_2105> optNbt) {
        this.optEntityTypeEntries = optEntityTypeEntries;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ENTITY.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, EntityCondition::parse);
    }

    public static Result<EntityCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen((? super S rootObject) -> rootObject.noUnused(EntityCondition::parse));
    }

    public static Result<EntityCondition, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<class_6885<class_1299<?>>> optEntityType = rootObject.get("entity_type").getSuccess().flatMap(entityElement -> BuiltinJson.parseEntityTypeOrEntityTypeTag(entityElement).ifFailure(problems::add).getSuccess());
        Optional<class_2105> optNbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbtPredicate(nbtElement).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new EntityCondition(optEntityType, optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(class_1297 entity) {
        return Optional.of(this.optEntityTypeEntries.map(entityTypeEntries -> entity.method_5864().method_53125(entityTypeEntries)).orElse(true) != false && this.optNbt.map(nbt -> nbt.method_9072(entity)).orElse(true) != false);
    }
}

