/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.server.data.CategoryData;

public class PlayerData {
    private final Map<class_2960, CategoryData> categories;

    private PlayerData(Map<class_2960, CategoryData> categories) {
        this.categories = categories;
    }

    public static PlayerData empty() {
        return new PlayerData(new HashMap<class_2960, CategoryData>());
    }

    public static PlayerData read(class_2487 nbt) {
        HashMap<class_2960, CategoryData> categories = new HashMap<class_2960, CategoryData>();
        class_2487 categoriesNbt = nbt.method_68568("categories");
        for (String id : categoriesNbt.method_10541()) {
            class_2520 elementNbt = categoriesNbt.method_10580(id);
            if (!(elementNbt instanceof class_2487)) continue;
            class_2487 categoryNbt = (class_2487)elementNbt;
            categories.put(SkillsMod.convertIdentifier(class_2960.method_60654((String)id)), CategoryData.read(categoryNbt));
        }
        return new PlayerData(categories);
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 categoriesNbt = new class_2487();
        for (Map.Entry<class_2960, CategoryData> entry : this.categories.entrySet()) {
            categoriesNbt.method_10566(entry.getKey().toString(), (class_2520)entry.getValue().writeNbt(new class_2487()));
        }
        nbt.method_10566("categories", (class_2520)categoriesNbt);
        return nbt;
    }

    public boolean isCategoryUnlocked(CategoryConfig category) {
        CategoryData categoryData = this.categories.get(category.id());
        if (categoryData != null) {
            return categoryData.isUnlocked();
        }
        return category.general().unlockedByDefault();
    }

    public CategoryData getOrCreateCategoryData(CategoryConfig category) {
        return this.categories.computeIfAbsent(category.id(), key -> CategoryData.create(category.general()));
    }

    public void removeCategoryData(CategoryConfig category) {
        this.categories.remove(category.id());
    }
}

