/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.reader.ConfigReader;

public class FileConfigReader
extends ConfigReader {
    private final Path modConfigDir;

    public FileConfigReader(Path modConfigDir) {
        this.modConfigDir = modConfigDir;
    }

    public Result<JsonElement, Problem> readFile(Path file) {
        return JsonElement.parseFile(file, JsonPath.create(this.modConfigDir.relativize(file).toString()));
    }

    @Override
    public Result<JsonElement, Problem> read(Path path) {
        return this.readFile(this.modConfigDir.resolve(path));
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(this.modConfigDir.resolve(path), new LinkOption[0]);
    }
}

