/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.util.LegacyUtils;

public record SkillConfig(String id, int x, int y, String definitionId, boolean isRoot) {
    public static Result<Optional<SkillConfig>, Problem> parse(String id, JsonElement rootElement, SkillDefinitionsConfig definitions, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(rootObject -> SkillConfig.parse(id, rootObject, definitions), context));
    }

    private static Result<Optional<SkillConfig>, Problem> parse(String id, JsonObject rootObject, SkillDefinitionsConfig definitions) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Integer> optX = rootObject.getInt("x").ifFailure(problems::add).getSuccess();
        Optional<Integer> optY = rootObject.getInt("y").ifFailure(problems::add).getSuccess();
        Optional optDefinitionId = rootObject.get("definition").andThen(definitionElement -> definitionElement.getAsString().andThen(definitionId -> {
            if (definitions.isValid((String)definitionId)) {
                return Result.success(definitionId);
            }
            return Result.failure(definitionElement.getPath().createProblem("Expected a valid definition"));
        })).ifFailure(problems::add).getSuccess();
        Boolean isRoot = rootObject.get("root").getSuccess().flatMap(element -> element.getAsBoolean().ifFailure(problems::add).getSuccess()).orElse(false);
        if (problems.isEmpty()) {
            String definitionId = (String)optDefinitionId.orElseThrow();
            if (definitions.isLoaded(definitionId)) {
                return Result.success(Optional.of(new SkillConfig(id, optX.orElseThrow(), optY.orElseThrow(), definitionId, isRoot)));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(Problem.combine(problems));
    }
}

