/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.keybinding.KeyBindingHandler;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketHandler;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.main.NeoForgeMain;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import org.apache.commons.lang3.ArrayUtils;

public class NeoForgeClientMain {
    private final List<ClientEventListener> clientListeners = new ArrayList<ClientEventListener>();
    private final List<KeyBindingWithHandler> keyBindings = new ArrayList<KeyBindingWithHandler>();
    private final Map<ResourceLocation, CustomPacketPayload.Type<NeoForgeMain.InOutPayload<?>>> outPackets = new HashMap();
    private final List<Consumer<PayloadRegistrar>> payloadRegistrations = new ArrayList<Consumer<PayloadRegistrar>>();

    public NeoForgeClientMain(IEventBus modEventBus) {
        SkillsClientMod.setup(new ClientRegistrarImpl(), new ClientEventReceiverImpl(), new KeyBindingReceiverImpl(), new ClientPacketSenderImpl());
        modEventBus.addListener(this::onRegisterPayloadHandler);
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        neoForgeEventBus.addListener(this::onPlayerLoggedIn);
        neoForgeEventBus.addListener(this::onInputKey);
    }

    private void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        for (ClientEventListener listener : this.clientListeners) {
            listener.onPlayerJoin();
        }
    }

    private void onInputKey(InputEvent.Key event) {
        for (KeyBindingWithHandler keyBinding : this.keyBindings) {
            if (!keyBinding.keyBinding.consumeClick()) continue;
            keyBinding.handler.handle();
        }
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("puffish_skills");
        for (Consumer<PayloadRegistrar> payloadRegistration : this.payloadRegistrations) {
            payloadRegistration.accept(registrar);
        }
    }

    private class ClientRegistrarImpl
    implements ClientRegistrar {
        private ClientRegistrarImpl() {
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<RegistryFriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
            CustomPacketPayload.Type pId = new CustomPacketPayload.Type(id);
            NeoForgeClientMain.this.payloadRegistrations.add(registrar -> registrar.playToClient(pId, CustomPacketPayload.codec((value, buf) -> value.outPacket().write((RegistryFriendlyByteBuf)buf), buf -> new NeoForgeMain.InOutPayload<InPacket>((CustomPacketPayload.Type<? extends CustomPacketPayload>)pId, (InPacket)reader.apply((RegistryFriendlyByteBuf)buf), null)), (payload, context) -> handler.handle((InPacket)payload.inValue())));
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
            NeoForgeClientMain.this.outPackets.put(id, new CustomPacketPayload.Type(id));
        }
    }

    private class ClientEventReceiverImpl
    implements ClientEventReceiver {
        private ClientEventReceiverImpl() {
        }

        @Override
        public void registerListener(ClientEventListener eventListener) {
            NeoForgeClientMain.this.clientListeners.add(eventListener);
        }
    }

    private class KeyBindingReceiverImpl
    implements KeyBindingReceiver {
        private KeyBindingReceiverImpl() {
        }

        @Override
        public void registerKeyBinding(KeyMapping keyBinding, KeyBindingHandler handler) {
            NeoForgeClientMain.this.keyBindings.add(new KeyBindingWithHandler(keyBinding, handler));
            Options options = Minecraft.getInstance().options;
            options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])options.keyMappings, (Object)keyBinding);
        }
    }

    private class ClientPacketSenderImpl
    implements ClientPacketSender {
        private ClientPacketSenderImpl() {
        }

        @Override
        public void send(OutPacket packet) {
            Objects.requireNonNull(Minecraft.getInstance().getConnection()).send((Packet)new ServerboundCustomPayloadPacket(new NeoForgeMain.InOutPayload<Object>(NeoForgeClientMain.this.outPackets.get(packet.getId()), null, packet)));
        }
    }

    private record KeyBindingWithHandler(KeyMapping keyBinding, KeyBindingHandler handler) {
    }
}

