/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_5455;
import net.minecraft.class_9329;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<class_1799, Boolean> {
    private final class_2073 predicate;
    private final Optional<class_2105> optNbt;

    private ItemStackCondition(class_2073 predicate, Optional<class_2105> optNbt) {
        this.predicate = predicate;
        this.optNbt = optNbt;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> ItemStackCondition.parse(rootObject, context), context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject, OperationConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<class_2105> optNbt = rootObject.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbtPredicate(nbtElement).ifFailure(problems::add).getSuccess());
        Optional optComponents = rootObject.get("components").getSuccess().flatMap(componentsElement -> BuiltinJson.parseComponentPredicate(componentsElement, (class_5455)context.getServer().method_30611()).ifFailure(problems::add).getSuccess());
        Optional optPredicates = rootObject.get("predicates").getSuccess().flatMap(predicatesElement -> BuiltinJson.parseItemSubPredicates(predicatesElement, (class_5455)context.getServer().method_30611()).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(new class_2073(optItem, class_2096.class_2100.field_9708, optComponents.orElse(class_9329.field_49597), optPredicates.orElseGet(Map::of)), optNbt));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(class_1799 itemStack) {
        return Optional.of(this.predicate.method_8970(itemStack) && this.optNbt.map(nbt -> nbt.method_9074(itemStack)).orElse(true) != false);
    }
}

