/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Events;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceFactory;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardFactory;
import net.puffish.skillsmod.experience.source.ExperienceSourceRegistry;
import net.puffish.skillsmod.impl.CategoryImpl;
import net.puffish.skillsmod.reward.RewardRegistry;

public final class SkillsAPI {
    public static final String MOD_ID = "puffish_skills";

    private SkillsAPI() {
    }

    public static void registerSkillUnlockEvent(Events.SkillUnlock event) {
        SkillsMod.SKILL_UNLOCK.register(event);
    }

    public static void registerSkillLockEvent(Events.SkillLock event) {
        SkillsMod.SKILL_LOCK.register(event);
    }

    public static void registerReward(ResourceLocation key, RewardFactory factory) {
        RewardRegistry.register(key, factory);
    }

    public static void registerExperienceSource(ResourceLocation key, ExperienceSourceFactory factory) {
        ExperienceSourceRegistry.register(key, factory);
    }

    public static void updateExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        SkillsMod.getInstance().visitExperienceSources(player, function);
    }

    public static <T extends ExperienceSource> void updateExperienceSources(ServerPlayer player, Class<T> clazz, Function<T, Integer> function) {
        SkillsMod.getInstance().visitExperienceSources(player, experienceSource -> {
            if (clazz.isInstance(experienceSource)) {
                return (Integer)function.apply((ExperienceSource)clazz.cast(experienceSource));
            }
            return 0;
        });
    }

    public static void updateRewards(ServerPlayer player, ResourceLocation id) {
        SkillsMod.getInstance().updateRewards(player, reward -> reward.type().equals((Object)id));
    }

    public static void updateRewards(ServerPlayer player, Predicate<Reward> predicate) {
        SkillsMod.getInstance().updateRewards(player, reward -> predicate.test(reward.instance()));
    }

    public static <T extends Reward> void updateRewards(ServerPlayer player, Class<T> clazz) {
        SkillsAPI.updateRewards(player, clazz::isInstance);
    }

    public static <T extends Reward> void updateRewards(ServerPlayer player, Class<T> clazz, Predicate<T> predicate) {
        SkillsAPI.updateRewards(player, (Reward reward) -> {
            if (clazz.isInstance(reward)) {
                return predicate.test((Reward)clazz.cast(reward));
            }
            return false;
        });
    }

    public static void openScreen(ServerPlayer player) {
        SkillsMod.getInstance().openScreen(player, Optional.empty());
    }

    public static Optional<Category> getCategory(ResourceLocation categoryId) {
        if (SkillsMod.getInstance().hasCategory(categoryId)) {
            return Optional.of(new CategoryImpl(categoryId));
        }
        return Optional.empty();
    }

    public static Stream<Category> streamCategories() {
        return SkillsMod.getInstance().getCategories(false).stream().map(CategoryImpl::new);
    }

    public static Stream<Category> streamUnlockedCategories(ServerPlayer player) {
        return SkillsMod.getInstance().getUnlockedCategories(player).stream().map(CategoryImpl::new);
    }
}

