/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.calculation.prototype.PrototypeImpl;

public class LegacyOperationRegistry<T> {
    private final PrototypeImpl<T> prototype;

    public LegacyOperationRegistry(Prototype<T> prototype) {
        this.prototype = (PrototypeImpl)prototype;
    }

    public <U> void registerBooleanFunction(String name, OperationFactory<U, Boolean> factory, Function<T, U> function) {
        this.prototype.registerLegacyOperation(this.createId(name), BuiltinPrototypes.NUMBER, factory.compose(function).andThen(b -> b != false ? 1.0 : 0.0));
    }

    public <U> void registerOptionalBooleanFunction(String name, OperationFactory<U, Boolean> factory, Function<T, Optional<U>> function) {
        this.prototype.registerLegacyOperation(this.createId(name), BuiltinPrototypes.NUMBER, factory.optional().compose(function).andThen(b -> b != false ? 1.0 : 0.0));
    }

    public <U, R> void registerNumberFunction(String name, Function<R, Double> postFunction, OperationFactory<U, R> factory, Function<T, U> function) {
        this.prototype.registerLegacyOperation(this.createId(name), BuiltinPrototypes.NUMBER, factory.compose(function).andThen(postFunction));
    }

    public void registerNumberFunction(String name, Function<T, Double> function) {
        this.prototype.registerLegacyOperation(this.createId(name), BuiltinPrototypes.NUMBER, context -> Result.success(t -> Optional.of((Double)function.apply(t))));
    }

    private ResourceLocation createId(String name) {
        return new ResourceLocation(this.prototype.getId().m_135827_(), "legacy_" + name);
    }
}

