/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.keybinding.KeyBindingHandler;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketHandler;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import org.apache.commons.lang3.ArrayUtils;

public class ForgeClientMain {
    private final List<ClientEventListener> clientListeners = new ArrayList<ClientEventListener>();
    private final List<KeyBindingWithHandler> keyBindings = new ArrayList<KeyBindingWithHandler>();

    public ForgeClientMain() {
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onPlayerLoggedIn);
        forgeEventBus.addListener(this::onInputKey);
        SkillsClientMod.setup(new ClientRegistrarImpl(), new ClientEventReceiverImpl(), new KeyBindingReceiverImpl(), new ClientPacketSenderImpl());
    }

    private void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        for (ClientEventListener listener : this.clientListeners) {
            listener.onPlayerJoin();
        }
    }

    private void onInputKey(InputEvent.KeyInputEvent event) {
        for (KeyBindingWithHandler keyBinding : this.keyBindings) {
            if (!keyBinding.keyBinding.m_90859_()) continue;
            keyBinding.handler.handle();
        }
    }

    private static class ClientRegistrarImpl
    implements ClientRegistrar {
        private ClientRegistrarImpl() {
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation identifier, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
            EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)identifier, () -> "1", version -> true, version -> true);
            channel.addListener(networkEvent -> {
                NetworkEvent.Context context = (NetworkEvent.Context)networkEvent.getSource().get();
                if (context.getPacketHandled()) {
                    return;
                }
                if (networkEvent instanceof NetworkEvent.ServerCustomPayloadEvent) {
                    NetworkEvent.ServerCustomPayloadEvent serverNetworkEvent = (NetworkEvent.ServerCustomPayloadEvent)networkEvent;
                    InPacket packet = (InPacket)reader.apply(serverNetworkEvent.getPayload());
                    context.enqueueWork(() -> handler.handle(packet));
                    context.setPacketHandled(true);
                }
            });
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
        }
    }

    private class ClientEventReceiverImpl
    implements ClientEventReceiver {
        private ClientEventReceiverImpl() {
        }

        @Override
        public void registerListener(ClientEventListener eventListener) {
            ForgeClientMain.this.clientListeners.add(eventListener);
        }
    }

    private class KeyBindingReceiverImpl
    implements KeyBindingReceiver {
        private KeyBindingReceiverImpl() {
        }

        @Override
        public void registerKeyBinding(KeyMapping keyBinding, KeyBindingHandler handler) {
            ForgeClientMain.this.keyBindings.add(new KeyBindingWithHandler(keyBinding, handler));
            Options options = Minecraft.m_91087_().f_91066_;
            options.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])options.f_92059_, (Object)keyBinding);
        }
    }

    private static class ClientPacketSenderImpl
    implements ClientPacketSender {
        private ClientPacketSenderImpl() {
        }

        @Override
        public void send(OutPacket packet) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.write(buf);
            Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104955_((Packet)new ServerboundCustomPayloadPacket(packet.getId(), buf));
        }
    }

    private record KeyBindingWithHandler(KeyMapping keyBinding, KeyBindingHandler handler) {
    }
}

