/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.main.ForgeClientMain;
import net.puffish.skillsmod.mixin.GameRulesAccessor;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerPlatform;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

@Mod(value="puffish_skills")
public class ForgeMain {
    private final List<ServerEventListener> serverListeners = new ArrayList<ServerEventListener>();

    public ForgeMain() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ForgeClientMain::new);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onPlayerLoggedIn);
        forgeEventBus.addListener(this::onPlayerLoggedOut);
        forgeEventBus.addListener(this::onServerStarting);
        forgeEventBus.addListener(this::onOnDatapackSyncEvent);
        forgeEventBus.addListener(this::onRegisterCommands);
        SkillsMod.setup(FMLPaths.CONFIGDIR.get(), new ServerRegistrarImpl(), new ServerEventReceiverImpl(), new ServerPacketSenderImpl(), new ServerPlatformImpl());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerJoin(serverPlayer);
            }
        }
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerLeave(serverPlayer);
            }
        }
    }

    private void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerStarting(server);
        }
    }

    private void onOnDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerReload(server);
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onCommandsRegister((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }

    private static class ServerRegistrarImpl
    implements ServerRegistrar {
        private ServerRegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)id.m_135827_());
            deferredRegister.register(id.m_135815_(), () -> entry);
            deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        }

        @Override
        public <T extends GameRules.Value<T>> void registerGameRule(GameRules.Key<T> key, GameRules.Type<T> type) {
            GameRulesAccessor.getRuleTypes().put(key, type);
        }

        @Override
        public <A extends ArgumentType<?>> void registerArgumentType(ResourceLocation id, Class<A> clazz, ArgumentSerializer<A> serializer) {
            ArgumentTypes.m_121601_((String)id.toString(), clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation identifier, Function<FriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
            EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)identifier, () -> "1", version -> true, version -> true);
            channel.addListener(networkEvent -> {
                NetworkEvent.Context context = (NetworkEvent.Context)networkEvent.getSource().get();
                if (context.getPacketHandled()) {
                    return;
                }
                if (networkEvent instanceof NetworkEvent.ClientCustomPayloadEvent) {
                    NetworkEvent.ClientCustomPayloadEvent serverNetworkEvent = (NetworkEvent.ClientCustomPayloadEvent)networkEvent;
                    InPacket packet = (InPacket)reader.apply(serverNetworkEvent.getPayload());
                    context.enqueueWork(() -> handler.handle(context.getSender(), packet));
                    context.setPacketHandled(true);
                }
            });
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
        }
    }

    private class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            ForgeMain.this.serverListeners.add(eventListener);
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(ServerPlayer player, OutPacket packet) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.write(buf);
            player.f_8906_.m_141995_((Packet)new ClientboundCustomPayloadPacket(packet.getId(), buf));
        }
    }

    private static class ServerPlatformImpl
    implements ServerPlatform {
        private ServerPlatformImpl() {
        }

        @Override
        public boolean isFakePlayer(ServerPlayer player) {
            return player instanceof FakePlayer;
        }
    }
}

