/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.keybinding.KeyBindingHandler;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketHandler;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.main.NeoForgeMain;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import org.apache.commons.lang3.ArrayUtils;

public class NeoForgeClientMain {
    private final List<ClientEventListener> clientListeners = new ArrayList<ClientEventListener>();
    private final List<KeyBindingWithHandler> keyBindings = new ArrayList<KeyBindingWithHandler>();

    public NeoForgeClientMain(Map<ResourceLocation, NeoForgeMain.PacketBuilder> packetBuilders) {
        SkillsClientMod.setup(new ClientRegistrarImpl(packetBuilders), new ClientEventReceiverImpl(), new KeyBindingReceiverImpl(), new ClientPacketSenderImpl());
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        neoForgeEventBus.addListener(this::onPlayerLoggedIn);
        neoForgeEventBus.addListener(this::onInputKey);
    }

    private void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        for (ClientEventListener listener : this.clientListeners) {
            listener.onPlayerJoin();
        }
    }

    private void onInputKey(InputEvent.Key event) {
        for (KeyBindingWithHandler keyBinding : this.keyBindings) {
            if (!keyBinding.keyBinding.consumeClick()) continue;
            keyBinding.handler.handle();
        }
    }

    private static class ClientRegistrarImpl
    implements ClientRegistrar {
        private final Map<ResourceLocation, NeoForgeMain.PacketBuilder> packetBuilders;

        private ClientRegistrarImpl(Map<ResourceLocation, NeoForgeMain.PacketBuilder> packetBuilders) {
            this.packetBuilders = packetBuilders;
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
            this.packetBuilders.computeIfAbsent(id, key -> new NeoForgeMain.PacketBuilder()).setClientHandler((IPlayPayloadHandler<NeoForgeMain.SharedCustomPayload>)((IPlayPayloadHandler)(payload, context) -> {
                InPacket packet = (InPacket)reader.apply(payload.data());
                context.workHandler().execute(() -> handler.handle(packet));
            }));
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
            this.packetBuilders.computeIfAbsent(id, key -> new NeoForgeMain.PacketBuilder()).fallbackServerHandler();
        }
    }

    private class ClientEventReceiverImpl
    implements ClientEventReceiver {
        private ClientEventReceiverImpl() {
        }

        @Override
        public void registerListener(ClientEventListener eventListener) {
            NeoForgeClientMain.this.clientListeners.add(eventListener);
        }
    }

    private class KeyBindingReceiverImpl
    implements KeyBindingReceiver {
        private KeyBindingReceiverImpl() {
        }

        @Override
        public void registerKeyBinding(KeyMapping keyBinding, KeyBindingHandler handler) {
            NeoForgeClientMain.this.keyBindings.add(new KeyBindingWithHandler(keyBinding, handler));
            Options options = Minecraft.getInstance().options;
            options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])options.keyMappings, (Object)keyBinding);
        }
    }

    private static class ClientPacketSenderImpl
    implements ClientPacketSender {
        private ClientPacketSenderImpl() {
        }

        @Override
        public void send(OutPacket packet) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            packet.write(buf);
            Objects.requireNonNull(Minecraft.getInstance().getConnection()).send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new NeoForgeMain.SharedCustomPayload(packet.getId(), buf)));
        }
    }

    private record KeyBindingWithHandler(KeyMapping keyBinding, KeyBindingHandler handler) {
    }
}

