/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.main.NeoForgeClientMain;
import net.puffish.skillsmod.mixin.GameRulesInvoker;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerPlatform;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

@Mod(value="puffish_skills")
public class NeoForgeMain {
    private final List<ServerEventListener> serverListeners = new ArrayList<ServerEventListener>();
    private final Map<ResourceLocation, CustomPacketPayload.Type<InOutPayload<?>>> outPackets = new HashMap();
    private final List<Consumer<PayloadRegistrar>> payloadRegistrations = new ArrayList<Consumer<PayloadRegistrar>>();

    public NeoForgeMain(IEventBus modEventBus, Dist dist) {
        if (dist.isClient()) {
            new NeoForgeClientMain(modEventBus);
        }
        SkillsMod.setup(FMLPaths.CONFIGDIR.get(), new ServerRegistrarImpl(modEventBus), new ServerEventReceiverImpl(), new ServerPacketSenderImpl(), new ServerPlatformImpl());
        modEventBus.addListener(this::onRegisterPayloadHandler);
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        neoForgeEventBus.addListener(this::onPlayerLoggedIn);
        neoForgeEventBus.addListener(this::onPlayerLoggedOut);
        neoForgeEventBus.addListener(this::onServerStarting);
        neoForgeEventBus.addListener(this::onOnDatapackSyncEvent);
        neoForgeEventBus.addListener(this::onRegisterCommands);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerJoin(serverPlayer);
            }
        }
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ServerEventListener listener : this.serverListeners) {
                listener.onPlayerLeave(serverPlayer);
            }
        }
    }

    private void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerStarting(server);
        }
    }

    private void onOnDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        MinecraftServer server = event.getPlayerList().getServer();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onServerReload(server);
        }
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        for (ServerEventListener listener : this.serverListeners) {
            listener.onCommandsRegister((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }

    public void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("puffish_skills");
        for (Consumer<PayloadRegistrar> payloadRegistration : this.payloadRegistrations) {
            payloadRegistration.accept(registrar);
        }
    }

    private class ServerRegistrarImpl
    implements ServerRegistrar {
        private final IEventBus modEventBus;

        public ServerRegistrarImpl(IEventBus modEventBus) {
            this.modEventBus = modEventBus;
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registry.key(), (String)id.getNamespace());
            deferredRegister.register(id.getPath(), () -> entry);
            deferredRegister.register(this.modEventBus);
        }

        @Override
        public <T extends GameRules.Value<T>> GameRules.Key<T> registerGameRule(String name, GameRules.Category category, GameRules.Type<T> type) {
            return GameRulesInvoker.invokeRegister(name, category, type);
        }

        @Override
        public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void registerArgumentType(ResourceLocation id, Class<A> clazz, ArgumentTypeInfo<A, T> serializer) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)id.getNamespace());
            deferredRegister.register(id.getPath(), () -> serializer);
            deferredRegister.register(this.modEventBus);
            ArgumentTypeInfos.registerByClass(clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<RegistryFriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
            CustomPacketPayload.Type pId = new CustomPacketPayload.Type(id);
            NeoForgeMain.this.payloadRegistrations.add(registrar -> registrar.playToServer(pId, CustomPacketPayload.codec((value, buf) -> value.outPacket.write((RegistryFriendlyByteBuf)buf), buf -> new InOutPayload<InPacket>((CustomPacketPayload.Type<? extends CustomPacketPayload>)pId, (InPacket)reader.apply((RegistryFriendlyByteBuf)buf), null)), (payload, context) -> handler.handle((ServerPlayer)context.player(), (InPacket)payload.inValue())));
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
            NeoForgeMain.this.outPackets.put(id, new CustomPacketPayload.Type(id));
            if (FMLEnvironment.getDist().isDedicatedServer()) {
                CustomPacketPayload.Type pId = new CustomPacketPayload.Type(id);
                NeoForgeMain.this.payloadRegistrations.add(registrar -> registrar.playToClient(pId, CustomPacketPayload.codec((value, buf) -> value.outPacket.write((RegistryFriendlyByteBuf)buf), buf -> null), (payload, context) -> {}));
            }
        }
    }

    private class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            NeoForgeMain.this.serverListeners.add(eventListener);
        }
    }

    private class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(ServerPlayer player, OutPacket packet) {
            player.connection.send((Packet)new ClientboundCustomPayloadPacket(new InOutPayload<Object>(NeoForgeMain.this.outPackets.get(packet.getId()), null, packet)));
        }
    }

    private static class ServerPlatformImpl
    implements ServerPlatform {
        private ServerPlatformImpl() {
        }

        @Override
        public boolean isFakePlayer(ServerPlayer player) {
            return player instanceof FakePlayer;
        }

        @Override
        public boolean isModLoaded(String id) {
            return ModList.get().isLoaded(id);
        }
    }

    public record InOutPayload<T>(CustomPacketPayload.Type<? extends CustomPacketPayload> id, T inValue, OutPacket outPacket) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.id;
        }
    }
}

