/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.puffish.skillsmod.server.data.PlayerData;

public class ServerData
extends SavedData {
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    private ServerData() {
    }

    private static ServerData read(CompoundTag tag) {
        ServerData playersData = new ServerData();
        CompoundTag playersNbt = tag.getCompoundOrEmpty("players");
        playersNbt.keySet().forEach(key -> playersData.players.put(UUID.fromString(key), PlayerData.read(playersNbt.getCompoundOrEmpty(key))));
        return playersData;
    }

    private CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag playersNbt = new CompoundTag();
        for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
            playersNbt.put(entry.getKey().toString(), (Tag)entry.getValue().writeNbt(new CompoundTag()));
        }
        nbt.put("players", (Tag)playersNbt);
        return nbt;
    }

    public static SavedDataType<ServerData> getPersistentStateType() {
        return new SavedDataType("puffish_skills", context -> new ServerData(), context -> new Codec<ServerData>(){

            public <T> DataResult<Pair<ServerData, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((Object)ServerData.read((CompoundTag)input)), input));
            }

            public <T> DataResult<T> encode(ServerData input, DynamicOps<T> ops, T prefix) {
                if (!(prefix instanceof EndTag)) {
                    throw new RuntimeException();
                }
                return DataResult.success((Object)input.writeNbt(new CompoundTag()));
            }
        }, null);
    }

    public static ServerData getOrCreate(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.overworld().getDataStorage();
        return (ServerData)persistentStateManager.computeIfAbsent(ServerData.getPersistentStateType());
    }

    public PlayerData getPlayerData(ServerPlayer player) {
        return this.players.computeIfAbsent(player.getUUID(), uuid -> PlayerData.empty());
    }

    public void putPlayerData(ServerPlayer player, PlayerData data) {
        this.players.put(player.getUUID(), data);
    }

    public boolean isDirty() {
        return true;
    }
}

