/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;

public record ClientBackgroundConfig(ResourceLocation texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(ResourceLocation textureId, int width, int height, BackgroundPosition position) {
        ResourceLocation id = SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"));
        Minecraft.getInstance().execute(() -> {
            ClientBackgroundTexture texture = new ClientBackgroundTexture(textureId);
            Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)texture);
        });
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends AbstractTexture
    implements Tickable {
        private final SpriteContents sprite;
        private final SpriteTicker animator;

        public ClientBackgroundTexture(ResourceLocation id) {
            this.sprite = Minecraft.getInstance().getResourceManager().getResource(id).flatMap(resource -> Optional.ofNullable(SpriteResourceLoader.create((Collection)SpriteLoader.DEFAULT_METADATA_SECTIONS).loadSprite(id, resource))).orElseGet(MissingTextureAtlasSprite::create);
            this.animator = this.sprite.createTicker();
            this.texture = RenderSystem.getDevice().createTexture(id.toString(), TextureFormat.RGBA8, this.sprite.width(), this.sprite.height(), 1);
            this.sprite.uploadFirstFrame(0, 0, this.texture);
        }

        public void tick() {
            if (this.animator != null) {
                this.animator.tickAndUpload(0, 0, this.texture);
            }
        }

        public void close() {
            this.sprite.close();
            if (this.animator != null) {
                this.animator.close();
            }
            super.close();
        }
    }
}

