/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.data.ClientSkillScreenData;
import net.puffish.skillsmod.client.network.packets.out.SkillClickOutPacket;
import net.puffish.skillsmod.client.rendering.ConnectionBatchedRenderer;
import net.puffish.skillsmod.client.rendering.ItemBatchedRenderer;
import net.puffish.skillsmod.client.rendering.TextureBatchedRenderer;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.util.Bounds2i;
import org.joml.Vector2i;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class SkillsScreen
extends Screen {
    private static final ResourceLocation WINDOW_TEXTURE = ResourceLocation.parse((String)"textures/gui/advancements/window.png");
    private static final ResourceLocation EXPERIENCE_BAR_BACKGROUND_TEXTURE = ResourceLocation.parse((String)"hud/experience_bar_background");
    private static final ResourceLocation EXPERIENCE_BAR_PROGRESS_TEXTURE = ResourceLocation.parse((String)"hud/experience_bar_progress");
    private static final ResourceLocation TAB_ABOVE_LEFT_SELECTED_TEXTURE = ResourceLocation.parse((String)"advancements/tab_above_left_selected");
    private static final ResourceLocation TAB_ABOVE_MIDDLE_SELECTED_TEXTURE = ResourceLocation.parse((String)"advancements/tab_above_middle_selected");
    private static final ResourceLocation TAB_ABOVE_LEFT_TEXTURE = ResourceLocation.parse((String)"advancements/tab_above_left");
    private static final ResourceLocation TAB_ABOVE_MIDDLE_TEXTURE = ResourceLocation.parse((String)"advancements/tab_above_middle");
    private static final WidgetSprites PAGE_FORWARD_TEXTURES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_TEXTURES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private static final ResourceLocation TRIAL_AVAILABLE_TEXTURE = ResourceLocation.parse((String)"icon/trial_available");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int FRAME_WIDTH = 252;
    private static final int FRAME_HEIGHT = 140;
    private static final int FRAME_PADDING = 8;
    private static final int FRAME_CUT = 16;
    private static final int FRAME_EXPAND = 24;
    private static final int CONTENT_GROW = 32;
    private static final int TABS_HEIGHT = 28;
    private static final int HALF_FRAME_WIDTH = 126;
    private static final int HALF_FRAME_HEIGHT = 70;
    private static final Vector4fc COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vector4fc COLOR_GRAY = new Vector4f(0.25f, 0.25f, 0.25f, 1.0f);
    private final ClientSkillScreenData data;
    private Optional<ClientCategoryData> optActiveCategoryData = Optional.empty();
    private Optional<ResourceLocation> optActiveCategoryId;
    private StateSwitchingButton nextButton;
    private StateSwitchingButton prevButton;
    private float minScale = 1.0f;
    private float maxScale = 1.0f;
    private double dragStartX = 0.0;
    private double dragStartY = 0.0;
    private double dragTotal = 0.0;
    private boolean canDrag = false;
    private Bounds2i bounds = Bounds2i.zero();
    private boolean small = false;
    private int contentPaddingTop = 0;
    private int contentPaddingLeft = 0;
    private int contentPaddingRight = 0;
    private int contentPaddingBottom = 0;

    public SkillsScreen(ClientSkillScreenData data, Optional<ResourceLocation> optCategoryId) {
        super(CommonComponents.EMPTY);
        this.data = data;
        this.optActiveCategoryId = optCategoryId;
    }

    protected void init() {
        super.init();
        this.resize();
    }

    public void resize(Minecraft client, int width, int height) {
        super.resize(client, width, height);
        this.resize();
    }

    private void resize() {
        this.small = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.hasExperience() && this.width < 450).orElse(false);
        if (this.small) {
            this.contentPaddingTop = 62;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        } else {
            this.contentPaddingTop = 54;
            this.contentPaddingLeft = 17;
            this.contentPaddingRight = 17;
            this.contentPaddingBottom = 17;
        }
        int halfWidth = this.width / 2;
        int halfHeight = this.height / 2;
        this.bounds = this.optActiveCategoryData.map(activeCategoryData -> activeCategoryData.getConfig().getBounds()).orElseGet(Bounds2i::zero);
        this.bounds.grow(32);
        this.bounds.extend(new Vector2i(this.contentPaddingLeft - halfWidth, this.contentPaddingTop - halfHeight));
        this.bounds.extend(new Vector2i(this.width - halfWidth - this.contentPaddingRight, this.height - halfHeight - this.contentPaddingBottom));
        int contentWidth = this.width - this.contentPaddingLeft - this.contentPaddingRight;
        int contentHeight = this.height - this.contentPaddingTop - this.contentPaddingBottom;
        int halfContentWidth = Mth.positiveCeilDiv((int)(this.bounds.height() * contentWidth), (int)(contentHeight * 2));
        int halfContentHeight = Mth.positiveCeilDiv((int)(this.bounds.width() * contentHeight), (int)(contentWidth * 2));
        this.bounds.extend(new Vector2i(-halfContentWidth, -halfContentHeight));
        this.bounds.extend(new Vector2i(halfContentWidth, halfContentHeight));
        this.minScale = Math.max((float)contentWidth / (float)this.bounds.width(), (float)contentHeight / (float)this.bounds.height());
        this.maxScale = 1.0f;
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits(activeCategoryData.getX(), activeCategoryData.getY(), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
        this.nextButton = new StateSwitchingButton(this.width - 8 - 12, 16, 12, 17, false){

            public void onClick(double mouseX, double mouseY) {
                SkillsScreen.this.data.incrementOffset();
            }
        };
        this.nextButton.initTextureValues(PAGE_FORWARD_TEXTURES);
        this.prevButton = new StateSwitchingButton(8, 16, 12, 17, true){

            public void onClick(double mouseX, double mouseY) {
                SkillsScreen.this.data.decrementOffset();
            }
        };
        this.prevButton.initTextureValues(PAGE_BACKWARD_TEXTURES);
    }

    private Vector2i getMousePos(double mouseX, double mouseY) {
        return new Vector2i((int)mouseX, (int)mouseY);
    }

    private Vector2i getTransformedMousePos(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        return new Vector2i((int)Math.round((mouseX - (double)activeCategoryData.getX() - (double)this.width / 2.0) / (double)activeCategoryData.getScale()), (int)Math.round((mouseY - (double)activeCategoryData.getY() - (double)this.height / 2.0) / (double)activeCategoryData.getScale()));
    }

    private boolean isInsideTab(Vector2i mouse, int x) {
        return mouse.x >= x && mouse.y >= 8 && mouse.x < x + 28 && mouse.y < 40;
    }

    private boolean isInsideSkill(Vector2i transformedMouse, ClientSkillConfig skill, ClientSkillDefinitionConfig definition) {
        int halfSize = Math.round(13.0f * definition.size());
        return transformedMouse.x >= skill.x() - halfSize && transformedMouse.y >= skill.y() - halfSize && transformedMouse.x < skill.x() + halfSize && transformedMouse.y < skill.y() + halfSize;
    }

    private boolean isInsideContent(Vector2i mouse) {
        return mouse.x >= this.contentPaddingLeft && mouse.y >= this.contentPaddingTop && mouse.x < this.width - this.contentPaddingRight && mouse.y < this.height - this.contentPaddingBottom;
    }

    private boolean isInsideExperience(Vector2i mouse, int x, int y) {
        return mouse.x >= x && mouse.y >= y && mouse.x < x + 182 && mouse.y < y + 5;
    }

    private boolean isInsideArea(Vector2i mouse, int x1, int y1, int x2, int y2) {
        return mouse.x >= x1 && mouse.y >= y1 && mouse.x < x2 && mouse.y < y2;
    }

    private void syncCategory() {
        Optional opt = this.optActiveCategoryId.flatMap(this.data::getCategory);
        opt.ifPresent(ClientCategoryData::updateLastOpen);
        if (this.optActiveCategoryData.isEmpty() || this.optActiveCategoryData.orElseThrow() != opt.orElse(null)) {
            this.optActiveCategoryData = this.data.getCategories().stream().max(Comparator.comparing(ClientCategoryData::getLastOpen));
            this.resize();
        }
        this.optActiveCategoryData.ifPresent(ClientCategoryData::updateUnseenPoints);
    }

    private int getTabX(int i) {
        return 8 + (i - this.data.getOffset()) * 32 + (this.data.getOffset() > 0 ? 15 : 0);
    }

    private void forEachVisibleTab(BiConsumer<Integer, ClientCategoryData> consumer) {
        Iterator<ClientCategoryData> it = this.data.getCategories().iterator();
        int i = 0;
        while (it.hasNext()) {
            ClientCategoryData category = it.next();
            int x = this.getTabX(i);
            if (x >= 8 && x + 28 <= this.width - 8 - 12 - 3) {
                consumer.accept(x, category);
            }
            ++i;
        }
    }

    private boolean hasNextButton() {
        int x = this.getTabX(this.data.getCategories().size() - 1);
        return x + 28 > this.width - 8 - 12 - 3;
    }

    private boolean hasPrevButton() {
        return this.data.getOffset() > 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseClickedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        if (this.hasNextButton()) {
            this.nextButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.hasPrevButton()) {
            this.prevButton.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    private void mouseClickedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        if (this.isInsideContent(mouse)) {
            this.dragStartX = mouseX - (double)activeCategoryData.getX();
            this.dragStartY = mouseY - (double)activeCategoryData.getY();
            this.dragTotal = 0.0;
            this.canDrag = true;
        } else {
            this.canDrag = false;
        }
        this.forEachVisibleTab((x, category) -> {
            if (this.isInsideTab(mouse, (int)x)) {
                this.optActiveCategoryId = Optional.ofNullable(category.getConfig().id());
                this.syncCategory();
            }
        });
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.dragTotal > 2.0) {
                return true;
            }
            this.optActiveCategoryData.ifPresent(activeCategoryData -> this.mouseReleasedWithCategory(mouseX, mouseY, (ClientCategoryData)activeCategoryData));
        }
        return true;
    }

    private void mouseReleasedWithCategory(double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        if (this.isInsideContent(mouse)) {
            for (ClientSkillConfig skill : activeCategory.skills().values()) {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(skill.definitionId());
                if (definition == null || !this.isInsideSkill(transformedMouse, skill, definition)) continue;
                SkillsClientMod.getInstance().getPacketSender().send(new SkillClickOutPacket(activeCategory.id(), skill.id()));
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (SkillsClientMod.OPEN_KEY_BINDING.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.syncCategory();
        this.renderBackground(context, mouseX, mouseY, delta);
        this.drawContent(context, mouseX, mouseY);
        this.drawWindow(context, mouseX, mouseY);
        this.drawTabs(context, mouseX, mouseY, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.canDrag) {
            return true;
        }
        if (button == 0) {
            this.dragTotal += Math.abs(deltaX);
            this.dragTotal += Math.abs(deltaY);
            if (this.dragTotal > 2.0) {
                this.optActiveCategoryData.ifPresent(activeCategoryData -> this.applyChangesWithLimits((int)Math.round(mouseX - this.dragStartX), (int)Math.round(mouseY - this.dragStartY), activeCategoryData.getScale(), (ClientCategoryData)activeCategoryData));
            }
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.optActiveCategoryData.ifPresent(activeCategoryData -> {
            float factor = (float)Math.pow(2.0, verticalAmount * 0.25);
            int x = activeCategoryData.getX();
            int y = activeCategoryData.getY();
            float scale = activeCategoryData.getScale();
            if ((scale *= factor) < this.minScale) {
                scale = this.minScale;
                factor = this.minScale / scale;
            }
            if (scale > this.maxScale) {
                scale = this.maxScale;
                factor = this.maxScale / scale;
            }
            this.applyChangesWithLimits(x - (int)Math.round((double)(factor - 1.0f) * (mouseX - (double)x - (double)((float)this.width / 2.0f))), y - (int)Math.round((double)(factor - 1.0f) * (mouseY - (double)y - (double)((float)this.height / 2.0f))), scale, (ClientCategoryData)activeCategoryData);
        });
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void applyChangesWithLimits(int x, int y, float scale, ClientCategoryData activeCategoryData) {
        int halfWidth = this.width / 2;
        int halfHeight = this.height / 2;
        activeCategoryData.setX(Mth.clamp((int)x, (int)((int)Math.ceil((float)(halfWidth - this.contentPaddingRight) - (float)this.bounds.max().x() * scale)), (int)((int)Math.floor((float)(this.contentPaddingLeft - halfWidth) - (float)this.bounds.min().x() * scale))));
        activeCategoryData.setY(Mth.clamp((int)y, (int)((int)Math.ceil((float)(halfHeight - this.contentPaddingBottom) - (float)this.bounds.max().y() * scale)), (int)((int)Math.floor((float)(this.contentPaddingTop - halfHeight) - (float)this.bounds.min().y() * scale))));
        activeCategoryData.setScale(Mth.clamp((float)scale, (float)this.minScale, (float)this.maxScale));
    }

    private void drawIcon(GuiGraphics context, TextureBatchedRenderer textureRenderer, ItemBatchedRenderer itemRenderer, ClientIconConfig icon, float sizeScale, int x, int y) {
        if (this.minecraft == null) {
            return;
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        if (icon instanceof ClientIconConfig.ItemIconConfig) {
            ClientIconConfig.ItemIconConfig itemIcon = (ClientIconConfig.ItemIconConfig)icon;
            matrices.translate((float)x * (1.0f - sizeScale), (float)y * (1.0f - sizeScale), 1.0f);
            matrices.scale(sizeScale, sizeScale, 1.0f);
            itemRenderer.emitItem(context, itemIcon.item(), x, y);
        } else if (icon instanceof ClientIconConfig.EffectIconConfig) {
            ClientIconConfig.EffectIconConfig effectIcon = (ClientIconConfig.EffectIconConfig)icon;
            matrices.translate(0.0f, 0.0f, 1.0f);
            TextureAtlasSprite sprite = this.minecraft.getMobEffectTextures().get(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effectIcon.effect()));
            int halfSize = Math.round(9.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitSprite(context, sprite, GuiSpriteScaling.DEFAULT, x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        } else if (icon instanceof ClientIconConfig.TextureIconConfig) {
            ClientIconConfig.TextureIconConfig textureIcon = (ClientIconConfig.TextureIconConfig)icon;
            matrices.translate(0.0f, 0.0f, 1.0f);
            int halfSize = Math.round(8.0f * sizeScale);
            int size = halfSize * 2;
            textureRenderer.emitTexture(context, textureIcon.texture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
        }
        matrices.popPose();
    }

    private void drawFrame(GuiGraphics context, TextureBatchedRenderer textureRenderer, ClientFrameConfig frame, float sizeScale, int x, int y, Skill.State state) {
        if (this.minecraft == null) {
            return;
        }
        int halfSize = Math.round(13.0f * sizeScale);
        int size = halfSize * 2;
        if (frame instanceof ClientFrameConfig.AdvancementFrameConfig) {
            ClientFrameConfig.AdvancementFrameConfig advancementFrame = (ClientFrameConfig.AdvancementFrameConfig)frame;
            GuiSpriteManager guiAtlasManager = this.minecraft.getGuiSprites();
            AdvancementWidgetType status = switch (state) {
                default -> throw new MatchException(null, null);
                case Skill.State.LOCKED, Skill.State.EXCLUDED, Skill.State.AVAILABLE, Skill.State.AFFORDABLE -> AdvancementWidgetType.UNOBTAINED;
                case Skill.State.UNLOCKED -> AdvancementWidgetType.OBTAINED;
            };
            ResourceLocation texture = status.frameSprite(advancementFrame.frame());
            TextureAtlasSprite sprite = guiAtlasManager.getSprite(texture);
            GuiSpriteScaling scaling = guiAtlasManager.getSpriteScaling(sprite);
            Vector4fc color = switch (state) {
                default -> throw new MatchException(null, null);
                case Skill.State.LOCKED, Skill.State.EXCLUDED -> COLOR_GRAY;
                case Skill.State.AVAILABLE, Skill.State.AFFORDABLE, Skill.State.UNLOCKED -> COLOR_WHITE;
            };
            textureRenderer.emitSprite(context, sprite, scaling, x - halfSize, y - halfSize, size, size, color);
        } else if (frame instanceof ClientFrameConfig.TextureFrameConfig) {
            ClientFrameConfig.TextureFrameConfig textureFrame = (ClientFrameConfig.TextureFrameConfig)frame;
            switch (state) {
                case LOCKED: {
                    textureFrame.lockedTexture().ifPresentOrElse(lockedTexture -> textureRenderer.emitTexture(context, (ResourceLocation)lockedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                case AVAILABLE: {
                    textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case AFFORDABLE: {
                    textureFrame.affordableTexture().ifPresentOrElse(affordableTexture -> textureRenderer.emitTexture(context, (ResourceLocation)affordableTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE));
                    break;
                }
                case UNLOCKED: {
                    textureRenderer.emitTexture(context, textureFrame.unlockedTexture(), x - halfSize, y - halfSize, size, size, COLOR_WHITE);
                    break;
                }
                case EXCLUDED: {
                    textureFrame.excludedTexture().ifPresentOrElse(excludedTexture -> textureRenderer.emitTexture(context, (ResourceLocation)excludedTexture, x - halfSize, y - halfSize, size, size, COLOR_WHITE), () -> textureRenderer.emitTexture(context, textureFrame.availableTexture(), x - halfSize, y - halfSize, size, size, COLOR_GRAY));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private void drawBackground(GuiGraphics context, ClientBackgroundConfig background) {
        int y;
        int x;
        int height;
        int width;
        BackgroundPosition position = background.position();
        switch (position) {
            case TILE: {
                context.blit(RenderType::guiTextured, background.texture(), this.bounds.min().x(), this.bounds.min().y(), 0.0f, 0.0f, this.bounds.width(), this.bounds.height(), background.width(), background.height());
                return;
            }
            case FILL: {
                if (this.bounds.width() * background.height() > background.width() * this.bounds.height()) {
                    position = BackgroundPosition.FILL_WIDTH;
                    break;
                }
                position = BackgroundPosition.FILL_HEIGHT;
                break;
            }
        }
        switch (position) {
            case NONE: {
                width = background.width();
                height = background.height();
                x = width / -2;
                y = height / -2;
                break;
            }
            case FILL_WIDTH: {
                x = this.bounds.min().x();
                width = this.bounds.width();
                y = -Mth.positiveCeilDiv((int)(background.height() * width), (int)(2 * background.width()));
                height = -2 * y;
                break;
            }
            case FILL_HEIGHT: {
                y = this.bounds.min().y();
                height = this.bounds.height();
                x = -Mth.positiveCeilDiv((int)(background.width() * height), (int)(2 * background.height()));
                width = -2 * x;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        context.blit(RenderType::guiTextured, background.texture(), x, y, 0.0f, 0.0f, width, height, width, height);
    }

    private void drawContent(GuiGraphics context, double mouseX, double mouseY) {
        context.enableScissor(this.contentPaddingLeft - 4, this.contentPaddingTop - 4, this.width - this.contentPaddingRight + 4, this.height - this.contentPaddingBottom + 4);
        context.fill(0, 0, this.width, this.height, -16777216);
        this.optActiveCategoryData.ifPresentOrElse(activeCategoryData -> this.drawContentWithCategory(context, mouseX, mouseY, (ClientCategoryData)activeCategoryData), () -> this.drawContentWithoutCategory(context));
        context.disableScissor();
    }

    private void drawContentWithCategory(GuiGraphics context, double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        if (this.minecraft == null) {
            return;
        }
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        Vector2i transformedMouse = this.getTransformedMousePos(mouseX, mouseY, activeCategoryData);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)activeCategoryData.getX() + (float)this.width / 2.0f, (float)activeCategoryData.getY() + (float)this.height / 2.0f, 1.0f);
        matrices.scale(activeCategoryData.getScale(), activeCategoryData.getScale(), 1.0f);
        this.drawBackground(context, activeCategory.background());
        matrices.translate(0.0f, 0.0f, 1.0f);
        ConnectionBatchedRenderer connectionRenderer = new ConnectionBatchedRenderer();
        for (ClientSkillConnectionConfig connection : activeCategory.normalConnections()) {
            activeCategoryData.getConnection(connection).ifPresent(relation -> connectionRenderer.emitConnection(context, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), connection.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
        }
        if (this.isInsideContent(mouse)) {
            Optional<ClientSkillConfig> optHoveredSkill = activeCategory.skills().values().stream().filter(skill -> activeCategory.getDefinitionById(skill.definitionId()).map(definition -> this.isInsideSkill(transformedMouse, (ClientSkillConfig)skill, (ClientSkillDefinitionConfig)definition)).orElse(false)).findFirst();
            optHoveredSkill.ifPresent(hoveredSkill -> {
                ClientSkillDefinitionConfig definition = activeCategory.definitions().get(hoveredSkill.definitionId());
                if (definition == null) {
                    return;
                }
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(definition.title().getVisualOrderText());
                lines.addAll(Tooltip.splitTooltip((Minecraft)this.minecraft, (Component)ComponentUtils.mergeStyles((MutableComponent)definition.description().copy(), (Style)Style.EMPTY.applyFormat(ChatFormatting.GRAY))));
                if (Screen.hasShiftDown()) {
                    lines.addAll(Tooltip.splitTooltip((Minecraft)this.minecraft, (Component)ComponentUtils.mergeStyles((MutableComponent)definition.extraDescription().copy(), (Style)Style.EMPTY.applyFormat(ChatFormatting.GRAY))));
                }
                if (this.minecraft.options.advancedItemTooltips) {
                    lines.add(Component.literal((String)hoveredSkill.id()).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
                }
                this.setTooltipForNextRenderPass(lines);
                Collection<ClientSkillConnectionConfig> connections = activeCategory.skillExclusiveConnections().get(hoveredSkill.id());
                if (connections != null) {
                    for (ClientSkillConnectionConfig connection : connections) {
                        activeCategoryData.getConnection(connection).ifPresent(relation -> connectionRenderer.emitConnection(context, relation.getSkillA().x(), relation.getSkillA().y(), relation.getSkillB().x(), relation.getSkillB().y(), connection.bidirectional(), relation.getColor().fill().argb(), relation.getColor().stroke().argb()));
                    }
                }
            });
        }
        context.flush();
        connectionRenderer.draw(context);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemRenderer = new ItemBatchedRenderer();
        for (ClientSkillConfig skill2 : activeCategory.skills().values()) {
            activeCategory.getDefinitionById(skill2.definitionId()).ifPresent(definition -> {
                this.drawFrame(context, textureRenderer, definition.frame(), definition.size(), skill2.x(), skill2.y(), activeCategoryData.getSkillState(skill2));
                this.drawIcon(context, textureRenderer, itemRenderer, definition.icon(), definition.size(), skill2.x(), skill2.y());
            });
        }
        textureRenderer.draw(context);
        itemRenderer.draw();
        matrices.popPose();
    }

    private void drawContentWithoutCategory(GuiGraphics context) {
        int tmpX = this.contentPaddingLeft + (this.width - this.contentPaddingLeft - this.contentPaddingRight) / 2;
        MutableComponent mutableComponent = Component.translatable((String)"advancements.sad_label");
        Objects.requireNonNull(this.font);
        context.drawCenteredString(this.font, (Component)mutableComponent, tmpX, this.height - this.contentPaddingBottom - 9, -1);
        MutableComponent mutableComponent2 = Component.translatable((String)"advancements.empty");
        Objects.requireNonNull(this.font);
        context.drawCenteredString(this.font, (Component)mutableComponent2, tmpX, this.contentPaddingTop + (this.height - this.contentPaddingTop - this.contentPaddingBottom - 9) / 2, -1);
    }

    private void drawTabs(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.minecraft == null) {
            return;
        }
        if (this.hasNextButton()) {
            this.nextButton.render(context, mouseX, mouseY, delta);
        }
        if (this.hasPrevButton()) {
            this.prevButton.render(context, mouseX, mouseY, delta);
        }
        this.forEachVisibleTab((x, category) -> context.blitSprite(RenderType::guiTexturedOverlay, this.optActiveCategoryData.orElse(null) == category ? (x == 8 ? TAB_ABOVE_LEFT_SELECTED_TEXTURE : TAB_ABOVE_MIDDLE_SELECTED_TEXTURE) : (x == 8 ? TAB_ABOVE_LEFT_TEXTURE : TAB_ABOVE_MIDDLE_TEXTURE), x.intValue(), 8, 28, 32));
        context.flush();
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        TextureBatchedRenderer textureRenderer = new TextureBatchedRenderer();
        ItemBatchedRenderer itemBatch = new ItemBatchedRenderer();
        this.forEachVisibleTab((x, category) -> {
            ClientCategoryConfig categoryConfig = category.getConfig();
            this.drawIcon(context, textureRenderer, itemBatch, categoryConfig.icon(), 1.0f, x + 6 + 8, 25);
            if (this.isInsideTab(mouse, (int)x)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(categoryConfig.title().getVisualOrderText());
                if (this.minecraft.options.advancedItemTooltips) {
                    lines.add(Component.literal((String)categoryConfig.id().toString()).withStyle(ChatFormatting.DARK_GRAY).getVisualOrderText());
                }
                this.setTooltipForNextRenderPass(lines);
            }
        });
        textureRenderer.draw(context);
        itemBatch.draw();
        this.forEachVisibleTab((x, category) -> {
            if (category.hasUnseenPoints()) {
                context.blitSprite(RenderType::guiTextured, TRIAL_AVAILABLE_TEXTURE, x + 10, 3, 8, 8);
            }
        });
    }

    private void drawWindow(GuiGraphics context, double mouseX, double mouseY) {
        if (this.minecraft == null) {
            return;
        }
        context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 8, this.height - 8 - 70, 0.0f, 70.0f, 126, 70, 256, 256);
        context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, this.width - 8 - 126, this.height - 8 - 70, 126.0f, 70.0f, 126, 70, 256, 256);
        context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 8, 78, 0.0f, 69.0f, 126, this.height - 16 - 140, 126, 2, 256, 256);
        context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 134, this.height - 8 - 70, 125.0f, 70.0f, this.width - 16 - 252, 70, 2, 70, 256, 256);
        context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, this.width - 8 - 126, 78, 126.0f, 69.0f, 126, this.height - 16 - 140, 126, 2, 256, 256);
        if (this.small) {
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 16, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 8, 52, 0.0f, 8.0f, 126, 26, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, this.width - 8 - 126, 36, 126.0f, 0.0f, 126, 16, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, this.width - 8 - 126, 52, 126.0f, 8.0f, 126, 26, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 134, 36, 125.0f, 0.0f, this.width - 16 - 252, 16, 2, 16, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 134, 52, 125.0f, 8.0f, this.width - 16 - 252, 54, 2, 54, 256, 256);
        } else {
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 8, 36, 0.0f, 0.0f, 126, 42, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, this.width - 8 - 126, 36, 126.0f, 0.0f, 126, 42, 256, 256);
            context.blit(RenderType::guiTexturedOverlay, WINDOW_TEXTURE, 134, 36, 125.0f, 0.0f, this.width - 16 - 252, 70, 2, 70, 256, 256);
        }
        MutableComponent tmpText = SkillsMod.createTranslatable("text", "skills", new Object[0]);
        int tmpX = 16;
        int tmpY = 42;
        context.drawString(this.font, (Component)tmpText, tmpX, tmpY, -12566464, false);
        this.optActiveCategoryData.ifPresent(activeCategoryData -> this.drawWindowWithCategory(context, mouseX, mouseY, (ClientCategoryData)activeCategoryData));
    }

    private void drawWindowWithCategory(GuiGraphics context, double mouseX, double mouseY, ClientCategoryData activeCategoryData) {
        Vector2i mouse = this.getMousePos(mouseX, mouseY);
        ClientCategoryConfig activeCategory = activeCategoryData.getConfig();
        int tmpX = this.width - 8 - 7;
        int tmpY = 42;
        int startX = tmpX;
        MutableComponent tmpText = Component.literal((String)(activeCategoryData.getPointsLeft() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategoryData.getSpentPointsLeft())));
        tmpX -= this.font.width((FormattedText)tmpText);
        ClientFillStrokeColorsConfig pointsColor = activeCategory.colors().points();
        int pointsStrokeColor = pointsColor.stroke().argb();
        int pointsFillColor = pointsColor.fill().argb();
        context.drawString(this.font, (Component)tmpText, --tmpX - 1, tmpY, pointsStrokeColor, false);
        context.drawString(this.font, (Component)tmpText, tmpX, tmpY - 1, pointsStrokeColor, false);
        context.drawString(this.font, (Component)tmpText, tmpX + 1, tmpY, pointsStrokeColor, false);
        context.drawString(this.font, (Component)tmpText, tmpX, tmpY + 1, pointsStrokeColor, false);
        context.drawString(this.font, (Component)tmpText, tmpX, tmpY, pointsFillColor, false);
        --tmpX;
        tmpText = SkillsMod.createTranslatable("text", "points_left", new Object[0]);
        context.drawString(this.font, (Component)tmpText, tmpX -= this.font.width((FormattedText)tmpText), tmpY, -12566464, false);
        Objects.requireNonNull(this.font);
        if (this.isInsideArea(mouse, tmpX, tmpY, startX, tmpY + 9)) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            lines.add(SkillsMod.createTranslatable("tooltip", "earned_points", activeCategoryData.getEarnedPoints()).getVisualOrderText());
            lines.add(SkillsMod.createTranslatable("tooltip", "spent_points", activeCategoryData.getSpentPoints() + (String)(activeCategory.spentPointsLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.spentPointsLimit())).getVisualOrderText());
            this.setTooltipForNextRenderPass(lines);
        }
        if (activeCategoryData.hasExperience()) {
            if (this.small) {
                tmpX = this.width - 8 - 8 - 182;
                tmpY = 53;
            } else {
                tmpX = (this.width - 182) / 2;
                tmpY = 43;
            }
            context.blitSprite(RenderType::guiTexturedOverlay, EXPERIENCE_BAR_BACKGROUND_TEXTURE, tmpX, tmpY, 182, 5);
            int width = Math.min(182, (int)(activeCategoryData.getExperienceProgress() * 183.0f));
            if (width > 0) {
                context.blitSprite(RenderType::guiTexturedOverlay, EXPERIENCE_BAR_PROGRESS_TEXTURE, 182, 5, 0, 0, tmpX, tmpY, width, 5);
            }
            if (this.isInsideExperience(mouse, tmpX, tmpY)) {
                ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
                lines.add(SkillsMod.createTranslatable("tooltip", "current_level", activeCategoryData.getCurrentLevel() + (String)(activeCategory.levelLimit() == Integer.MAX_VALUE ? "" : "/" + activeCategory.levelLimit())).getVisualOrderText());
                lines.add(SkillsMod.createTranslatable("tooltip", "experience_progress", activeCategoryData.getCurrentExperience(), activeCategoryData.getRequiredExperience(), Mth.floor((float)(activeCategoryData.getExperienceProgress() * 100.0f))).getVisualOrderText());
                lines.add(SkillsMod.createTranslatable("tooltip", "to_next_level", activeCategoryData.getExperienceToNextLevel()).getVisualOrderText());
                this.setTooltipForNextRenderPass(lines);
            }
        }
    }
}

