/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1162;
import net.minecraft.class_241;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class ConnectionBatchedRenderer {
    private final Int2ObjectMap<List<TriangleEmit>> strokeBatch = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<List<TriangleEmit>> fillBatch = new Int2ObjectOpenHashMap();

    public void emitConnection(class_4587 matrices, float startX, float startY, float endX, float endY, boolean bidirectional, int fillColor, int strokeColor) {
        class_1159 matrix = matrices.method_23760().method_23761();
        this.emitLine(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 3.0f);
        if (!bidirectional) {
            this.emitArrow(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 8.0f);
        }
        this.emitLine(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 1.0f);
        if (!bidirectional) {
            this.emitArrow(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 6.0f);
        }
    }

    private void emitLine(Int2ObjectMap<List<TriangleEmit>> batch, class_1159 matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        class_241 side = new class_241(endX, endY).method_35586(new class_241(-startX, -startY)).method_35581();
        side = new class_241(side.field_1342, -side.field_1343).method_35582(thickness / 2.0f);
        this.emitTriangle(batch, matrix, color, startX + side.field_1343, startY + side.field_1342, startX - side.field_1343, startY - side.field_1342, endX + side.field_1343, endY + side.field_1342);
        this.emitTriangle(batch, matrix, color, endX - side.field_1343, endY - side.field_1342, endX + side.field_1343, endY + side.field_1342, startX - side.field_1343, startY - side.field_1342);
    }

    private void emitArrow(Int2ObjectMap<List<TriangleEmit>> batch, class_1159 matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        class_241 center = new class_241(endX, endY).method_35586(new class_241(startX, startY)).method_35582(0.5f);
        class_241 normal = new class_241(endX, endY).method_35586(new class_241(-startX, -startY)).method_35581();
        class_241 forward = new class_241(normal.field_1343, normal.field_1342).method_35582(thickness);
        class_241 backward = new class_241(forward.field_1343, forward.field_1342).method_35582(-0.5f);
        class_241 back = new class_241(center.field_1343, center.field_1342).method_35586(backward);
        class_241 side = new class_241(backward.field_1342, -backward.field_1343).method_35582(class_3532.method_15355((float)3.0f));
        this.emitTriangle(batch, matrix, color, center.field_1343 + forward.field_1343, center.field_1342 + forward.field_1342, back.field_1343 - side.field_1343, back.field_1342 - side.field_1342, back.field_1343 + side.field_1343, back.field_1342 + side.field_1342);
    }

    private void emitTriangle(Int2ObjectMap<List<TriangleEmit>> batch, class_1159 matrix, int color, float x1, float y1, float x2, float y2, float x3, float y3) {
        class_1162 v1 = new class_1162(x1, y1, 0.0f, 1.0f);
        class_1162 v2 = new class_1162(x2, y2, 0.0f, 1.0f);
        class_1162 v3 = new class_1162(x3, y3, 0.0f, 1.0f);
        v1.method_22674(matrix);
        v2.method_22674(matrix);
        v3.method_22674(matrix);
        List emits = (List)batch.computeIfAbsent(color, key -> new ArrayList());
        emits.add(new TriangleEmit(v1.method_4953(), v1.method_4956(), v1.method_4957(), v2.method_4953(), v2.method_4956(), v2.method_4957(), v3.method_4953(), v3.method_4956(), v3.method_4957()));
    }

    public void draw() {
        RenderSystem.setShader(class_757::method_34539);
        this.drawBatch(this.strokeBatch);
        this.drawBatch(this.fillBatch);
    }

    private void drawBatch(Int2ObjectMap<List<TriangleEmit>> batch) {
        RenderSystem.setShader(class_757::method_34539);
        for (Int2ObjectMap.Entry entry : batch.int2ObjectEntrySet()) {
            int color = entry.getIntKey();
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
            for (TriangleEmit emit : (List)entry.getValue()) {
                bufferBuilder.method_22912((double)emit.x1, (double)emit.y1, (double)emit.z1).method_1344();
                bufferBuilder.method_22912((double)emit.x2, (double)emit.y2, (double)emit.z2).method_1344();
                bufferBuilder.method_22912((double)emit.x3, (double)emit.y3, (double)emit.z3).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        batch.clear();
    }

    private record TriangleEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
    }
}

