/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientConnectionsColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.common.FrameType;
import net.puffish.skillsmod.common.IconType;
import net.puffish.skillsmod.network.InPacket;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientCategoryData category;

    private ShowCategoryInPacket(ClientCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(FriendlyByteBuf buf) {
        ClientCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientCategoryData readCategory(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        Component title = buf.m_130238_();
        Component description = buf.m_130238_();
        Component extraDescription = buf.m_130238_();
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        ClientBackgroundConfig background = ShowCategoryInPacket.readBackground(buf);
        ClientColorsConfig colors = ShowCategoryInPacket.readColors(buf);
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionConfig> definitions = buf.m_236845_(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionConfig::id, definition -> definition));
        Map<String, ClientSkillConfig> skills = buf.m_236845_(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillConfig::id, skill -> skill));
        List normalConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        Map skillsStates = buf.m_236847_(FriendlyByteBuf::m_130277_, buf1 -> (Skill.State)buf1.m_130066_(Skill.State.class));
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int levelLimit = Integer.MAX_VALUE;
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            levelLimit = buf.readInt();
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        ClientCategoryConfig category = new ClientCategoryConfig(id, title, description, extraDescription, icon, background, colors, exclusiveRoot, spentPointsLimit, levelLimit, definitions, skills, normalConnections, exclusiveConnections);
        return new ClientCategoryData(category, skillsStates, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionConfig readDefinition(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        Component title = buf.m_130238_();
        Component description = buf.m_130238_();
        Component extraDescription = buf.m_130238_();
        ClientFrameConfig frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        int cost = buf.readInt();
        int requiredSkills = buf.readInt();
        int requiredPoints = buf.readInt();
        int requiredSpentPoints = buf.readInt();
        int requiredExclusions = buf.readInt();
        return new ClientSkillDefinitionConfig(id, title, description, extraDescription, icon, frame, size, cost, requiredSkills, requiredPoints, requiredSpentPoints, requiredExclusions);
    }

    public static ClientIconConfig readSkillIcon(FriendlyByteBuf buf) {
        IconType type = (IconType)buf.m_130066_(IconType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case IconType.EFFECT -> {
                ResourceLocation effect = buf.m_130281_();
                yield new ClientIconConfig.EffectIconConfig((MobEffect)Registry.f_122823_.m_7745_(effect));
            }
            case IconType.ITEM -> {
                ItemStack itemStack = buf.m_130267_();
                yield new ClientIconConfig.ItemIconConfig(itemStack);
            }
            case IconType.TEXTURE -> {
                ResourceLocation texture = buf.m_130281_();
                yield new ClientIconConfig.TextureIconConfig(texture);
            }
        };
    }

    public static ClientFrameConfig readFrameIcon(FriendlyByteBuf buf) {
        FrameType type = (FrameType)buf.m_130066_(FrameType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FrameType.ADVANCEMENT -> {
                net.minecraft.advancements.FrameType advancementFrame = (net.minecraft.advancements.FrameType)buf.m_130066_(net.minecraft.advancements.FrameType.class);
                yield new ClientFrameConfig.AdvancementFrameConfig(advancementFrame);
            }
            case FrameType.TEXTURE -> {
                Optional lockedTexture = buf.m_236860_(FriendlyByteBuf::m_130281_);
                ResourceLocation availableTexture = buf.m_130281_();
                Optional affordableTexture = buf.m_236860_(FriendlyByteBuf::m_130281_);
                ResourceLocation unlockedTexture = buf.m_130281_();
                Optional excludedTexture = buf.m_236860_(FriendlyByteBuf::m_130281_);
                yield new ClientFrameConfig.TextureFrameConfig(lockedTexture, availableTexture, affordableTexture, unlockedTexture, excludedTexture);
            }
        };
    }

    public static ClientBackgroundConfig readBackground(FriendlyByteBuf buf) {
        ResourceLocation texture = buf.m_130281_();
        int width = buf.readInt();
        int height = buf.readInt();
        BackgroundPosition position = (BackgroundPosition)buf.m_130066_(BackgroundPosition.class);
        return ClientBackgroundConfig.create(texture, width, height, position);
    }

    public static ClientColorsConfig readColors(FriendlyByteBuf buf) {
        ClientConnectionsColorsConfig connections = ShowCategoryInPacket.readConnectionsColors(buf);
        ClientFillStrokeColorsConfig points = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientColorsConfig(connections, points);
    }

    public static ClientConnectionsColorsConfig readConnectionsColors(FriendlyByteBuf buf) {
        ClientFillStrokeColorsConfig locked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig available = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig affordable = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig unlocked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig excluded = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientConnectionsColorsConfig(locked, available, affordable, unlocked, excluded);
    }

    public static ClientFillStrokeColorsConfig readFillStrokeColors(FriendlyByteBuf buf) {
        ClientColorConfig fill = ShowCategoryInPacket.readColor(buf);
        ClientColorConfig stroke = ShowCategoryInPacket.readColor(buf);
        return new ClientFillStrokeColorsConfig(fill, stroke);
    }

    public static ClientColorConfig readColor(FriendlyByteBuf buf) {
        int argb = buf.readInt();
        return new ClientColorConfig(argb);
    }

    public static ClientSkillConfig readSkill(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.m_130277_();
        boolean isRoot = buf.readBoolean();
        return new ClientSkillConfig(id, x, y, definition, isRoot);
    }

    public static ClientSkillConnectionConfig readSkillConnection(FriendlyByteBuf buf) {
        String skillAId = buf.m_130277_();
        String skillBId = buf.m_130277_();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionConfig(skillAId, skillBId, bidirectional);
    }

    public ClientCategoryData getCategory() {
        return this.category;
    }
}

