/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.util;

import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.puffish.skillsmod.experience.source.builtin.util.TamedActivity;

public record AttackerInfo(ServerPlayer player, boolean isTamed) {
    public static void detect(Entity entity, Consumer<AttackerInfo> consumer) {
        OwnableEntity tameable;
        Entity entity2;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            consumer.accept(new AttackerInfo(player, false));
        } else if (entity instanceof OwnableEntity && (entity2 = (tameable = (OwnableEntity)entity).m_21826_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            consumer.accept(new AttackerInfo(player, true));
        }
    }

    public boolean matchesTamedActivity(TamedActivity tamedActivity) {
        return switch (tamedActivity) {
            default -> throw new IncompatibleClassChangeError();
            case TamedActivity.EXCLUDE -> {
                if (!this.isTamed) {
                    yield true;
                }
                yield false;
            }
            case TamedActivity.INCLUDE -> true;
            case TamedActivity.ONLY -> this.isTamed;
        };
    }
}

