/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;

public record ClientBackgroundConfig(ResourceLocation texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(ResourceLocation textureId, int width, int height, BackgroundPosition position) {
        ResourceLocation id = SkillsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"));
        Minecraft.m_91087_().execute(() -> {
            ClientBackgroundTexture texture = new ClientBackgroundTexture(textureId);
            Minecraft.m_91087_().m_91097_().m_118495_(id, (AbstractTexture)texture);
        });
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends AbstractTexture
    implements Tickable {
        private final ResourceLocation id;
        private SpriteContents sprite;
        private SpriteTicker animator;

        public ClientBackgroundTexture(ResourceLocation id) {
            this.id = id;
        }

        public void m_6704_(ResourceManager manager) {
            this.sprite = manager.m_213713_(this.id).flatMap(resource -> Optional.ofNullable(SpriteLoader.m_245083_((ResourceLocation)this.id, (Resource)resource))).orElseGet(MissingTextureAtlasSprite::m_246104_);
            this.animator = this.sprite.m_246786_();
            RenderSystem.m_69879_(() -> {
                this.m_117966_();
                TextureUtil.m_85287_((int)this.m_117963_(), (int)0, (int)this.sprite.m_246492_(), (int)this.sprite.m_245330_());
                this.sprite.m_246850_(0, 0);
            });
        }

        public void m_7673_() {
            this.m_117966_();
            if (this.animator != null) {
                this.animator.m_247697_(0, 0);
            }
        }

        public void close() {
            this.sprite.close();
            if (this.animator != null) {
                this.animator.close();
            }
            super.close();
        }
    }
}

