/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerChunk;
import net.puffish.skillsmod.experience.source.builtin.util.AntiFarmingPerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;
    @Unique
    private final Map<class_3222, Float> damageShare = new WeakHashMap<class_3222, Float>();
    @Unique
    private final AntiFarmingPerEntity.Data antiFarmingData = new AntiFarmingPerEntity.Data();

    @Inject(method={"method_6025(F)V"}, at={@At(value="TAIL")})
    private void injectAtHeal(float amount, CallbackInfo ci) {
        class_1309 class_13092;
        if (amount > 0.0f && (class_13092 = (class_1309)this) instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            SkillsAPI.updateExperienceSources(player, HealExperienceSource.class, experienceSource -> experienceSource.getValue(player, amount));
        }
    }

    @Inject(method={"method_6074(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)V"}, at={@At(value="TAIL")})
    private void injectAtApplyDamage(class_3218 world, class_1282 source, float damage, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        class_1799 weapon = ((DamageSourceAccess)source).getWeapon().orElse(class_1799.field_8037);
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            this.damageShare.compute(player, (key, value) -> {
                if (value == null) {
                    return Float.valueOf(damage);
                }
                return Float.valueOf(value.floatValue() + damage);
            });
            this.antiFarmingData.removeOutdated();
            SkillsAPI.updateExperienceSources(player, DealDamageExperienceSource.class, experienceSource -> {
                float limitedDamage = experienceSource.getAntiFarming().map(antiFarming -> Float.valueOf(this.antiFarmingData.addAndLimit((AntiFarmingPerEntity)antiFarming, damage))).orElse(Float.valueOf(damage)).floatValue();
                if (limitedDamage > 1.0E-5f) {
                    return experienceSource.getValue(player, entity, weapon, limitedDamage, source);
                }
                return 0;
            });
        }
    }

    @Inject(method={"method_16080(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;)V"}, at={@At(value="TAIL")})
    private void injectAtDrop(class_3218 world, class_1282 source, CallbackInfo ci) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_1309 entity = (class_1309)this;
            class_1799 weapon = ((DamageSourceAccess)source).getWeapon().orElse(class_1799.field_8037);
            AntiFarmingPerChunk.Data antiFarmingData = ((WorldChunkAccess)entity.method_37908().method_8500(entity.method_24515())).getAntiFarmingData();
            antiFarmingData.removeOutdated();
            SkillsAPI.updateExperienceSources(player, KillEntityExperienceSource.class, experienceSource -> {
                if (experienceSource.getAntiFarming().map(antiFarmingData::tryIncrement).orElse(true).booleanValue()) {
                    return experienceSource.getValue(player, entity, weapon, source, this.entityDroppedXp);
                }
                return 0;
            });
            Set<Map.Entry<class_3222, Float>> entries = this.damageShare.entrySet();
            double totalDamage = entries.stream().mapToDouble(Map.Entry::getValue).sum();
            for (Map.Entry<class_3222, Float> entry : entries) {
                SkillsAPI.updateExperienceSources(entry.getKey(), SharedKillEntityExperienceSource.class, experienceSource -> {
                    if (experienceSource.getAntiFarming().map(antiFarmingData::tryIncrement).orElse(true).booleanValue()) {
                        return experienceSource.getValue((class_3222)entry.getKey(), entity, weapon, source, this.entityDroppedXp, totalDamage, entries.size(), (double)((Float)entry.getValue()).floatValue() / totalDamage);
                    }
                    return 0;
                });
            }
        }
    }

    @ModifyArg(method={"method_23883(Lnet/minecraft/class_3218;Lnet/minecraft/class_1297;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_1303;method_31493(Lnet/minecraft/class_3218;Lnet/minecraft/class_243;I)V"), index=2)
    private int injectAtDropExperience(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }
}

