/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.NbtPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BuiltinJson {
    private BuiltinJson() {
    }

    public static Result<Identifier, Problem> parseIdentifier(JsonElement element) {
        return BuiltinJson.parseFromString(element, Identifier::parse, "identifier");
    }

    public static Result<String, Problem> parseIdentifierPath(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> Identifier.withDefaultNamespace((String)s).getPath(), "identifier path");
    }

    public static Result<MobEffect, Problem> parseEffect(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.MOB_EFFECT, "effect");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.MOB_EFFECT, "effect");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectOrEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.MOB_EFFECT, "effect");
    }

    public static Result<Block, Problem> parseBlock(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.BLOCK, "block");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.BLOCK, "block");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockOrBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.BLOCK, "block");
    }

    public static Result<DamageType, Problem> parseDamageType(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomething(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), "damage type");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingTag(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), "damage type");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeOrDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, manager.lookupOrThrow(Registries.DAMAGE_TYPE), "damage type");
    }

    public static Result<EntityType<?>, Problem> parseEntityType(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.ENTITY_TYPE, "entity type");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.ENTITY_TYPE, "entity type");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeOrEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.ENTITY_TYPE, "entity type");
    }

    public static Result<Item, Problem> parseItem(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.ITEM, "item");
    }

    public static Result<HolderSet<Item>, Problem> parseItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.ITEM, "item");
    }

    public static Result<HolderSet<Item>, Problem> parseItemOrItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.ITEM, "item");
    }

    public static Result<StatType<?>, Problem> parseStatType(JsonElement element) {
        return BuiltinJson.parseSomething(element, BuiltInRegistries.STAT_TYPE, "stat type");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(element, BuiltInRegistries.STAT_TYPE, "stat type");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeOrStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(element, BuiltInRegistries.STAT_TYPE, "stat type");
    }

    public static Result<StatePropertiesPredicate, Problem> parseStatePredicate(JsonElement element) {
        try {
            return Result.success((StatePropertiesPredicate)StatePropertiesPredicate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected state predicate"));
        }
    }

    public static Result<NbtPredicate, Problem> parseNbtPredicate(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return new NbtPredicate(TagParser.parseCompoundFully((String)s));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "nbt predicate");
    }

    public static Result<DataComponentMatchers, Problem> parseComponentsPredicate(JsonElement element, RegistryAccess manager) {
        try {
            return Result.success((DataComponentMatchers)DataComponentMatchers.CODEC.codec().parse((DynamicOps)manager.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected component predicate"));
        }
    }

    public static Result<Stat<?>, Problem> parseStat(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> BuiltinJson.getOrCreateStat((StatType)BuiltInRegistries.STAT_TYPE.getOptional(Identifier.bySeparator((String)id.getNamespace(), (char)'.')).orElseThrow(), Identifier.bySeparator((String)id.getPath(), (char)'.')), "stat");
    }

    private static <T> Stat<T> getOrCreateStat(StatType<T> statType, Identifier id) {
        return statType.get(statType.getRegistry().getOptional(id).orElseThrow());
    }

    public static Result<CompoundTag, Problem> parseNbt(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> {
            try {
                return TagParser.parseCompoundFully((String)s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "nbt");
    }

    @Deprecated
    public static Result<DataComponentPatch, Problem> parseComponentChanges(JsonElement element) {
        return BuiltinJson.parseComponentChanges(element, null);
    }

    public static Result<DataComponentPatch, Problem> parseComponentChanges(JsonElement element, RegistryAccess manager) {
        try {
            JsonOps ops = manager == null ? JsonOps.INSTANCE : manager.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            return Result.success((DataComponentPatch)DataComponentPatch.CODEC.parse((DynamicOps)ops, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected components"));
        }
    }

    @Deprecated
    public static Result<ItemStack, Problem> parseItemStack(JsonElement element) {
        return BuiltinJson.parseItemStack(element, null);
    }

    public static Result<ItemStack, Problem> parseItemStack(JsonElement element, RegistryAccess manager) {
        try {
            return element.getAsObject().andThen(rootObject -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                Optional item = rootObject.get("item").andThen(BuiltinJson::parseItem).ifFailure(problems::add).getSuccess();
                Optional components = rootObject.get("components").getSuccess().flatMap(nbtElement -> BuiltinJson.parseComponentChanges(nbtElement, manager).ifFailure(problems::add).getSuccess());
                if (problems.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    components.ifPresent(arg_0 -> ((ItemStack)itemStack).applyComponentsAndValidate(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Problem.combine(problems));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected item stack"));
        }
    }

    public static Result<AdvancementType, Problem> parseFrame(JsonElement element) {
        try {
            return Result.success((AdvancementType)AdvancementType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected frame"));
        }
    }

    public static Result<Component, Problem> parseText(JsonElement element, RegistryAccess manager) {
        try {
            return Result.success((Component)ComponentSerialization.CODEC.parse((DynamicOps)manager.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)element.getJson()).result().orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected text"));
        }
    }

    public static Result<Attribute, Problem> parseAttribute(JsonElement element) {
        return BuiltinJson.parseFromIdentifier(element, id -> {
            if (id.getNamespace().equals("puffish_skills")) {
                id = Identifier.fromNamespaceAndPath((String)"puffish_attributes", (String)id.getPath());
            }
            return (Attribute)BuiltInRegistries.ATTRIBUTE.getOptional(id).orElseThrow();
        }, "attribute");
    }

    public static Result<AttributeModifier.Operation, Problem> parseAttributeOperation(JsonElement element) {
        return BuiltinJson.parseFromString(element, s -> switch (s) {
            case "add", "add_value", "addition" -> AttributeModifier.Operation.ADD_VALUE;
            case "multiply_base", "add_multiplied_base" -> AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            case "multiply_total", "add_multiplied_total" -> AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            default -> throw new RuntimeException();
        }, "attribute operation");
    }

    private static <T> Result<T, Problem> parseFromString(JsonElement element, Function<String, T> parser, String what) {
        try {
            String s = element.getJson().getAsString();
            try {
                return Result.success(parser.apply(s));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Invalid " + what + " `" + s + "`"));
            }
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem("Expected " + what));
        }
    }

    private static <T> Result<T, Problem> parseFromIdentifier(JsonElement element, Function<Identifier, T> parser, String what) {
        return BuiltinJson.parseFromString(element, Identifier::parse, what).andThen(id -> {
            try {
                return Result.success(parser.apply((Identifier)id));
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Unknown " + what + " `" + String.valueOf(id) + "`"));
            }
        });
    }

    private static <T> Result<T, Problem> parseSomething(JsonElement element, Registry<T> registry, String what) {
        return BuiltinJson.parseFromIdentifier(element, id -> registry.getOptional(id).orElseThrow(), what);
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingTag(JsonElement element, Registry<T> registry, String what) {
        return BuiltinJson.parseFromString(element, s -> s.startsWith("#") ? Identifier.parse((String)s.substring(1)) : Identifier.parse((String)s), what).andThen(id -> {
            try {
                return Result.success((HolderSet)registry.get(TagKey.create((ResourceKey)registry.key(), (Identifier)id)).orElseThrow());
            }
            catch (Exception ignored) {
                return Result.failure(element.getPath().createProblem("Unknown " + what + " tag `" + String.valueOf(id) + "`"));
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static <T> Result<HolderSet<T>, Problem> parseSomethingOrSomethingTag(JsonElement element, Registry<T> registry, String what) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

