/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TickableTexture;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.common.BackgroundPosition;
import org.apache.commons.lang3.RandomStringUtils;
import org.lwjgl.system.MemoryUtil;

public record ClientBackgroundConfig(Identifier texture, int width, int height, BackgroundPosition position) {
    public static ClientBackgroundConfig create(Identifier textureId, int width, int height, BackgroundPosition position) {
        Identifier id = SkillsMod.createIdentifier(RandomStringUtils.insecure().next(16, "abcdefghijklmnopqrstuvwxyz0123456789"));
        Minecraft client = Minecraft.getInstance();
        client.execute(() -> client.getTextureManager().register(id, (AbstractTexture)new ClientBackgroundTexture(textureId)));
        return new ClientBackgroundConfig(id, width, height, position);
    }

    private static class ClientBackgroundTexture
    extends AbstractTexture
    implements TickableTexture {
        private final SpriteContents contents;
        private final SpriteContents.AnimationState animator;
        private final GpuBuffer gpuBuffer;

        public ClientBackgroundTexture(Identifier id) {
            this.sampler = RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST);
            this.contents = Minecraft.getInstance().getResourceManager().getResource(id).flatMap(resource -> Optional.ofNullable(SpriteResourceLoader.create(Set.of(GuiMetadataSection.TYPE)).loadSprite(id, resource))).orElseGet(MissingTextureAtlasSprite::create);
            int size = Mth.roundToward((int)SpriteContents.UBO_SIZE, (int)RenderSystem.getDevice().getUniformOffsetAlignment());
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)size);
            ClientBackgroundSprite sprite = new ClientBackgroundSprite(id, this.contents);
            sprite.uploadSpriteUbo(byteBuffer, 0, 0, this.contents.width(), this.contents.height(), size);
            this.gpuBuffer = RenderSystem.getDevice().createBuffer(() -> ((Identifier)id).toString(), 128, byteBuffer);
            this.animator = this.contents.createAnimationState(this.gpuBuffer.slice(), size);
            this.texture = RenderSystem.getDevice().createTexture(id.toString(), 13, TextureFormat.RGBA8, this.contents.width(), this.contents.height(), 1, 1);
            this.textureView = RenderSystem.getDevice().createTextureView(this.texture);
            this.contents.uploadFirstFrame(this.texture, 0);
        }

        public void tick() {
            if (this.animator != null) {
                this.animator.tick();
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Animate " + String.valueOf(this.contents.name()), this.textureView, OptionalInt.empty());){
                    if (this.animator.needsToDraw()) {
                        this.animator.drawToAtlas(renderPass, this.animator.getDrawUbo(0));
                    }
                }
            }
        }

        public void close() {
            this.gpuBuffer.close();
            this.contents.close();
            if (this.animator != null) {
                this.animator.close();
            }
            super.close();
        }
    }

    private static class ClientBackgroundSprite
    extends TextureAtlasSprite {
        private ClientBackgroundSprite(Identifier id, SpriteContents contents) {
            super(id, contents, contents.width(), contents.height(), 0, 0, 0);
        }
    }
}

