/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.Identifier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientConnectionsColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.common.FrameType;
import net.puffish.skillsmod.common.IconType;
import net.puffish.skillsmod.network.InPacket;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientCategoryData category;

    private ShowCategoryInPacket(ClientCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(RegistryFriendlyByteBuf buf) {
        ClientCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientCategoryData readCategory(RegistryFriendlyByteBuf buf) {
        Identifier id = buf.readIdentifier();
        Component title = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        Component description = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        Component extraDescription = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        ClientBackgroundConfig background = ShowCategoryInPacket.readBackground((FriendlyByteBuf)buf);
        ClientColorsConfig colors = ShowCategoryInPacket.readColors((FriendlyByteBuf)buf);
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionConfig> definitions = buf.readList(buf1 -> ShowCategoryInPacket.readDefinition(buf)).stream().collect(Collectors.toMap(ClientSkillDefinitionConfig::id, definition -> definition));
        Map<String, ClientSkillConfig> skills = buf.readList(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillConfig::id, skill -> skill));
        List normalConnections = buf.readList(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.readList(ShowCategoryInPacket::readSkillConnection);
        Map skillsStates = buf.readMap(FriendlyByteBuf::readUtf, buf1 -> (Skill.State)buf1.readEnum(Skill.State.class));
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int levelLimit = Integer.MAX_VALUE;
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            levelLimit = buf.readInt();
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        ClientCategoryConfig category = new ClientCategoryConfig(id, title, description, extraDescription, icon, background, colors, exclusiveRoot, spentPointsLimit, levelLimit, definitions, skills, normalConnections, exclusiveConnections);
        return new ClientCategoryData(category, skillsStates, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionConfig readDefinition(RegistryFriendlyByteBuf buf) {
        String id = buf.readUtf();
        Component title = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        Component description = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        Component extraDescription = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
        ClientFrameConfig frame = ShowCategoryInPacket.readFrameIcon((FriendlyByteBuf)buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        int cost = buf.readInt();
        int requiredSkills = buf.readInt();
        int requiredPoints = buf.readInt();
        int requiredSpentPoints = buf.readInt();
        int requiredExclusions = buf.readInt();
        return new ClientSkillDefinitionConfig(id, title, description, extraDescription, icon, frame, size, cost, requiredSkills, requiredPoints, requiredSpentPoints, requiredExclusions);
    }

    public static ClientIconConfig readSkillIcon(RegistryFriendlyByteBuf buf) {
        IconType type = (IconType)buf.readEnum(IconType.class);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case IconType.EFFECT -> {
                Identifier effect = buf.readIdentifier();
                yield new ClientIconConfig.EffectIconConfig((MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(effect));
            }
            case IconType.ITEM -> {
                ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                yield new ClientIconConfig.ItemIconConfig(itemStack);
            }
            case IconType.TEXTURE -> {
                Identifier texture = buf.readIdentifier();
                yield new ClientIconConfig.TextureIconConfig(texture);
            }
        };
    }

    public static ClientFrameConfig readFrameIcon(FriendlyByteBuf buf) {
        FrameType type = (FrameType)buf.readEnum(FrameType.class);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FrameType.ADVANCEMENT -> {
                AdvancementType advancementFrame = (AdvancementType)buf.readEnum(AdvancementType.class);
                yield new ClientFrameConfig.AdvancementFrameConfig(advancementFrame);
            }
            case FrameType.TEXTURE -> {
                Optional lockedTexture = buf.readOptional(FriendlyByteBuf::readIdentifier);
                Identifier availableTexture = buf.readIdentifier();
                Optional affordableTexture = buf.readOptional(FriendlyByteBuf::readIdentifier);
                Identifier unlockedTexture = buf.readIdentifier();
                Optional excludedTexture = buf.readOptional(FriendlyByteBuf::readIdentifier);
                yield new ClientFrameConfig.TextureFrameConfig(lockedTexture, availableTexture, affordableTexture, unlockedTexture, excludedTexture);
            }
        };
    }

    public static ClientBackgroundConfig readBackground(FriendlyByteBuf buf) {
        Identifier texture = buf.readIdentifier();
        int width = buf.readInt();
        int height = buf.readInt();
        BackgroundPosition position = (BackgroundPosition)buf.readEnum(BackgroundPosition.class);
        return ClientBackgroundConfig.create(texture, width, height, position);
    }

    public static ClientColorsConfig readColors(FriendlyByteBuf buf) {
        ClientConnectionsColorsConfig connections = ShowCategoryInPacket.readConnectionsColors(buf);
        ClientFillStrokeColorsConfig points = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientColorsConfig(connections, points);
    }

    public static ClientConnectionsColorsConfig readConnectionsColors(FriendlyByteBuf buf) {
        ClientFillStrokeColorsConfig locked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig available = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig affordable = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig unlocked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig excluded = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientConnectionsColorsConfig(locked, available, affordable, unlocked, excluded);
    }

    public static ClientFillStrokeColorsConfig readFillStrokeColors(FriendlyByteBuf buf) {
        ClientColorConfig fill = ShowCategoryInPacket.readColor(buf);
        ClientColorConfig stroke = ShowCategoryInPacket.readColor(buf);
        return new ClientFillStrokeColorsConfig(fill, stroke);
    }

    public static ClientColorConfig readColor(FriendlyByteBuf buf) {
        int argb = buf.readInt();
        return new ClientColorConfig(argb);
    }

    public static ClientSkillConfig readSkill(FriendlyByteBuf buf) {
        String id = buf.readUtf();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.readUtf();
        boolean isRoot = buf.readBoolean();
        return new ClientSkillConfig(id, x, y, definition, isRoot);
    }

    public static ClientSkillConnectionConfig readSkillConnection(FriendlyByteBuf buf) {
        String skillAId = buf.readUtf();
        String skillBId = buf.readUtf();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionConfig(skillAId, skillBId, bidirectional);
    }

    public ClientCategoryData getCategory() {
        return this.category;
    }
}

