/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionCheck;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.commands.arguments.CategoryArgumentType;
import net.puffish.skillsmod.util.CommandUtils;

public class CategoryCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"category").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.literal((String)"lock").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(CategoryCommand::lock))))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(CategoryCommand::unlock))))).then(Commands.literal((String)"erase").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(CategoryCommand::erase))))).then(Commands.literal((String)"open").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"category", (ArgumentType)CategoryArgumentType.category()).executes(CategoryCommand::open))));
    }

    private static int lock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.lock(player);
        }
        CommandUtils.sendSuccess(context, players, "category.lock", category.getId());
        return players.size();
    }

    private static int unlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.unlock(player);
        }
        CommandUtils.sendSuccess(context, players, "category.unlock", category.getId());
        return players.size();
    }

    private static int erase(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.erase(player);
        }
        CommandUtils.sendSuccess(context, players, "category.erase", category.getId());
        return players.size();
    }

    private static int open(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        Category category = CategoryArgumentType.getCategory(context, "category");
        for (ServerPlayer player : players) {
            category.openScreen(player);
        }
        CommandUtils.sendSuccess(context, players, "category.open", category.getId());
        return players.size();
    }
}

