/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl;

import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Experience;

public class ExperienceImpl
implements Experience {
    private final Identifier categoryId;

    public ExperienceImpl(Identifier categoryId) {
        this.categoryId = categoryId;
    }

    @Override
    public int getTotal(ServerPlayer player) {
        return SkillsMod.getInstance().getExperience(player, this.categoryId).orElseThrow();
    }

    @Override
    public void setTotal(ServerPlayer player, int amount) {
        SkillsMod.getInstance().setExperience(player, this.categoryId, amount);
    }

    @Override
    public void addTotal(ServerPlayer player, int amount) {
        SkillsMod.getInstance().addExperience(player, this.categoryId, amount);
    }

    @Override
    public int getLevel(ServerPlayer player) {
        return SkillsMod.getInstance().getCurrentLevel(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getCurrent(ServerPlayer player) {
        return SkillsMod.getInstance().getCurrentExperience(player, this.categoryId).orElseThrow();
    }

    @Override
    public int getRequired(int level) {
        return SkillsMod.getInstance().getRequiredExperience(this.categoryId, level).orElseThrow();
    }

    @Override
    public int getRequired(ServerPlayer player, int level) {
        return this.getRequired(level);
    }

    @Override
    public int getRequiredTotal(int level) {
        return SkillsMod.getInstance().getRequiredTotalExperience(this.categoryId, level).orElseThrow();
    }

    @Override
    public int getRequiredTotal(ServerPlayer player, int level) {
        return this.getRequiredTotal(level);
    }
}

