/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import net.puffish.skillsmod.access.DrawContextAccess;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ConnectionBatchedRenderer {
    private final List<QuadEmit> strokeBatch = new ArrayList<QuadEmit>();
    private final List<QuadEmit> fillBatch = new ArrayList<QuadEmit>();

    public void emitConnection(GuiGraphics context, float startX, float startY, float endX, float endY, boolean bidirectional, int fillColor, int strokeColor) {
        Matrix3x2fStack matrix = context.pose();
        this.emitLine(this.strokeBatch, (Matrix3x2f)matrix, strokeColor, startX, startY, endX, endY, 3.0f);
        if (!bidirectional) {
            this.emitArrow(this.strokeBatch, (Matrix3x2f)matrix, strokeColor, startX, startY, endX, endY, 8.0f);
        }
        this.emitLine(this.fillBatch, (Matrix3x2f)matrix, fillColor, startX, startY, endX, endY, 1.0f);
        if (!bidirectional) {
            this.emitArrow(this.fillBatch, (Matrix3x2f)matrix, fillColor, startX, startY, endX, endY, 6.0f);
        }
    }

    private void emitLine(List<QuadEmit> batch, Matrix3x2f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f side = new Vector2f(endX, endY).sub(startX, startY).normalize().perpendicular().mul(thickness / 2.0f);
        this.emitQuad(batch, matrix, color, startX + side.x, startY + side.y, startX - side.x, startY - side.y, endX - side.x, endY - side.y, endX + side.x, endY + side.y);
    }

    private void emitArrow(List<QuadEmit> batch, Matrix3x2f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f center = new Vector2f(endX, endY).add(startX, startY).div(2.0f);
        Vector2f normal = new Vector2f(endX, endY).sub(startX, startY).normalize();
        Vector2f forward = new Vector2f((Vector2fc)normal).mul(thickness);
        Vector2f backward = new Vector2f((Vector2fc)forward).div(-2.0f);
        Vector2f back = new Vector2f((Vector2fc)center).add((Vector2fc)backward);
        Vector2f side = new Vector2f((Vector2fc)backward).perpendicular().mul(Mth.sqrt((float)3.0f));
        this.emitQuad(batch, matrix, color, center.x + forward.x, center.y + forward.y, back.x - side.x, back.y - side.y, back.x, back.y, back.x + side.x, back.y + side.y);
    }

    private void emitQuad(List<QuadEmit> batch, Matrix3x2f matrix, int color, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        Vector2f v1 = matrix.transformPosition(new Vector2f(x1, y1));
        Vector2f v2 = matrix.transformPosition(new Vector2f(x2, y2));
        Vector2f v3 = matrix.transformPosition(new Vector2f(x3, y3));
        Vector2f v4 = matrix.transformPosition(new Vector2f(x4, y4));
        batch.add(new QuadEmit(v1.x, v1.y, v2.x, v2.y, v3.x, v3.y, v4.x, v4.y, color));
    }

    public void draw(GuiGraphics context, ScreenRectangle scissorArea) {
        this.drawBatch(context, this.strokeBatch, scissorArea);
        this.drawBatch(context, this.fillBatch, scissorArea);
    }

    private void drawBatch(GuiGraphics context, List<QuadEmit> batch, final ScreenRectangle scissorArea) {
        if (batch.isEmpty()) {
            return;
        }
        final ScreenRectangle bounds = ConnectionBatchedRenderer.calcBounds(batch);
        final List<QuadEmit> batchCopy = List.copyOf(batch);
        batch.clear();
        DrawContextAccess contextAccess = (DrawContextAccess)context;
        contextAccess.getState().submitGuiElement(new GuiElementRenderState(){

            public void buildVertices(VertexConsumer vc, float depth) {
                for (QuadEmit emit : batchCopy) {
                    vc.addVertex(emit.x1, emit.y1, depth).setColor(emit.color());
                    vc.addVertex(emit.x2, emit.y2, depth).setColor(emit.color());
                    vc.addVertex(emit.x3, emit.y3, depth).setColor(emit.color());
                    vc.addVertex(emit.x4, emit.y4, depth).setColor(emit.color());
                }
            }

            public RenderPipeline pipeline() {
                return RenderPipelines.GUI;
            }

            public TextureSetup textureSetup() {
                return TextureSetup.noTexture();
            }

            public ScreenRectangle scissorArea() {
                return scissorArea;
            }

            public ScreenRectangle bounds() {
                return bounds;
            }
        });
    }

    @NotNull
    private static ScreenRectangle calcBounds(List<@NotNull QuadEmit> batchCopy) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        for (QuadEmit emit : batchCopy) {
            minX = Math.min(minX, emit.x1);
            minX = Math.min(minX, emit.x2);
            minX = Math.min(minX, emit.x3);
            minX = Math.min(minX, emit.x4);
            minY = Math.min(minY, emit.y1);
            minY = Math.min(minY, emit.y2);
            minY = Math.min(minY, emit.y3);
            minY = Math.min(minY, emit.y4);
            maxX = Math.max(maxX, emit.x1);
            maxX = Math.max(maxX, emit.x2);
            maxX = Math.max(maxX, emit.x3);
            maxX = Math.max(maxX, emit.x4);
            maxY = Math.max(maxY, emit.y1);
            maxY = Math.max(maxY, emit.y2);
            maxY = Math.max(maxY, emit.y3);
            maxY = Math.max(maxY, emit.y4);
        }
        return new ScreenRectangle(Mth.floor((float)minX), Mth.floor((float)minY), Mth.ceil((float)(maxX - minX)), Mth.ceil((float)(maxY - minY)));
    }

    private record QuadEmit(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int color) {
    }
}

