/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.util.CommandUtils;

public class CategoryArgumentType
implements ArgumentType<ResourceLocation> {
    private static final DynamicCommandExceptionType NO_SUCH_CATEGORY = new DynamicCommandExceptionType(id -> SkillsMod.createTranslatable("command", "no_such_category", id));
    private final boolean onlyWithExperience;

    public CategoryArgumentType(boolean onlyWithExperience) {
        this.onlyWithExperience = onlyWithExperience;
    }

    public static CategoryArgumentType category() {
        return new CategoryArgumentType(false);
    }

    public static CategoryArgumentType categoryOnlyWithExperience() {
        return new CategoryArgumentType(true);
    }

    public static Category getCategory(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation categoryId = SkillsMod.convertIdentifier((ResourceLocation)context.getArgument(name, ResourceLocation.class));
        return SkillsAPI.getCategory(categoryId).orElseThrow(() -> NO_SUCH_CATEGORY.create((Object)categoryId));
    }

    public static Category getCategoryOnlyWithExperience(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation categoryId = SkillsMod.convertIdentifier((ResourceLocation)context.getArgument(name, ResourceLocation.class));
        return SkillsAPI.getCategory(categoryId).filter(category -> category.getExperience().isPresent()).orElseThrow(() -> NO_SUCH_CATEGORY.create((Object)categoryId));
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.m_135818_((StringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object source = context.getSource();
        if (source instanceof CommandSourceStack) {
            CommandUtils.suggestIdentifiers(SkillsMod.getInstance().getCategories(this.onlyWithExperience), builder);
            return builder.buildFuture();
        }
        if (source instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider commandSource = (SharedSuggestionProvider)source;
            return commandSource.m_212155_(context);
        }
        return Suggestions.empty();
    }

    public static class Serializer
    implements ArgumentSerializer<CategoryArgumentType> {
        public void toPacket(CategoryArgumentType argumentType, FriendlyByteBuf buf) {
            buf.writeBoolean(argumentType.onlyWithExperience);
        }

        public CategoryArgumentType fromPacket(FriendlyByteBuf buf) {
            return new CategoryArgumentType(buf.readBoolean());
        }

        public void toJson(CategoryArgumentType argumentType, JsonObject jsonObject) {
            jsonObject.addProperty("only_with_experience", Boolean.valueOf(argumentType.onlyWithExperience));
        }
    }
}

