/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.reader;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.util.PathUtils;

public class PackConfigReader
extends ConfigReader {
    private final ResourceManager resourceManager;
    private final String namespace;

    public PackConfigReader(ResourceManager resourceManager, String namespace) {
        this.resourceManager = resourceManager;
        this.namespace = namespace;
    }

    public Result<JsonElement, Problem> readResource(ResourceLocation id, Resource resource) {
        Result<JsonElement, Problem> result;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
        try {
            result = JsonElement.parseReader(reader, JsonPath.create(id.toString()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Result.failure(Problem.message("Failed to read resource `" + String.valueOf(id) + "`"));
            }
        }
        reader.close();
        return result;
    }

    @Override
    public Result<JsonElement, Problem> read(Path path) {
        ResourceLocation id = new ResourceLocation(this.namespace, PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        try {
            return this.readResource(id, this.resourceManager.m_142591_(id));
        }
        catch (FileNotFoundException e) {
            return Result.failure(Problem.message("Resource `" + String.valueOf(id) + "` does not exist"));
        }
        catch (IOException e) {
            return Result.failure(Problem.message("Failed to read resource `" + String.valueOf(id) + "`"));
        }
    }

    @Override
    public boolean exists(Path path) {
        ResourceLocation id = new ResourceLocation(this.namespace, PathUtils.pathToString(Path.of("puffish_skills", new String[0]).resolve(path)));
        try {
            this.resourceManager.m_142591_(id);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

