/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientConnectionsColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.common.BackgroundPosition;
import net.puffish.skillsmod.common.FrameType;
import net.puffish.skillsmod.common.IconType;
import net.puffish.skillsmod.network.InPacket;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientCategoryData category;

    private ShowCategoryInPacket(ClientCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(class_2540 buf) {
        ClientCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientCategoryData readCategory(class_2540 buf) {
        class_2960 id = buf.method_10810();
        class_2561 title = buf.method_10808();
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        ClientBackgroundConfig background = ShowCategoryInPacket.readBackground(buf);
        ClientColorsConfig colors = ShowCategoryInPacket.readColors(buf);
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionConfig> definitions = buf.method_34066(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionConfig::id, definition -> definition));
        Map<String, ClientSkillConfig> skills = buf.method_34066(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillConfig::id, skill -> skill));
        List normalConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.method_34066(ShowCategoryInPacket::readSkillConnection);
        Map skillsStates = buf.method_34067(class_2540::method_19772, buf1 -> (Skill.State)buf1.method_10818(Skill.State.class));
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int levelLimit = Integer.MAX_VALUE;
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            levelLimit = buf.readInt();
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        ClientCategoryConfig category = new ClientCategoryConfig(id, title, icon, background, colors, exclusiveRoot, spentPointsLimit, levelLimit, definitions, skills, normalConnections, exclusiveConnections);
        return new ClientCategoryData(category, skillsStates, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionConfig readDefinition(class_2540 buf) {
        String id = buf.method_19772();
        class_2561 title = buf.method_10808();
        class_2561 description = buf.method_10808();
        class_2561 extraDescription = buf.method_10808();
        ClientFrameConfig frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        int cost = buf.readInt();
        int requiredSkills = buf.readInt();
        int requiredPoints = buf.readInt();
        int requiredSpentPoints = buf.readInt();
        int requiredExclusions = buf.readInt();
        return new ClientSkillDefinitionConfig(id, title, description, extraDescription, icon, frame, size, cost, requiredSkills, requiredPoints, requiredSpentPoints, requiredExclusions);
    }

    public static ClientIconConfig readSkillIcon(class_2540 buf) {
        IconType type = (IconType)buf.method_10818(IconType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case IconType.EFFECT -> {
                class_2960 effect = buf.method_10810();
                yield new ClientIconConfig.EffectIconConfig((class_1291)class_7923.field_41174.method_10223(effect));
            }
            case IconType.ITEM -> {
                class_1799 itemStack = buf.method_10819();
                yield new ClientIconConfig.ItemIconConfig(itemStack);
            }
            case IconType.TEXTURE -> {
                class_2960 texture = buf.method_10810();
                yield new ClientIconConfig.TextureIconConfig(texture);
            }
        };
    }

    public static ClientFrameConfig readFrameIcon(class_2540 buf) {
        FrameType type = (FrameType)buf.method_10818(FrameType.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FrameType.ADVANCEMENT -> {
                class_189 advancementFrame = (class_189)buf.method_10818(class_189.class);
                yield new ClientFrameConfig.AdvancementFrameConfig(advancementFrame);
            }
            case FrameType.TEXTURE -> {
                Optional lockedTexture = buf.method_37436(class_2540::method_10810);
                class_2960 availableTexture = buf.method_10810();
                Optional affordableTexture = buf.method_37436(class_2540::method_10810);
                class_2960 unlockedTexture = buf.method_10810();
                Optional excludedTexture = buf.method_37436(class_2540::method_10810);
                yield new ClientFrameConfig.TextureFrameConfig(lockedTexture, availableTexture, affordableTexture, unlockedTexture, excludedTexture);
            }
        };
    }

    public static ClientBackgroundConfig readBackground(class_2540 buf) {
        class_2960 texture = buf.method_10810();
        int width = buf.readInt();
        int height = buf.readInt();
        BackgroundPosition position = (BackgroundPosition)buf.method_10818(BackgroundPosition.class);
        return ClientBackgroundConfig.create(texture, width, height, position);
    }

    public static ClientColorsConfig readColors(class_2540 buf) {
        ClientConnectionsColorsConfig connections = ShowCategoryInPacket.readConnectionsColors(buf);
        ClientFillStrokeColorsConfig points = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientColorsConfig(connections, points);
    }

    public static ClientConnectionsColorsConfig readConnectionsColors(class_2540 buf) {
        ClientFillStrokeColorsConfig locked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig available = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig affordable = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig unlocked = ShowCategoryInPacket.readFillStrokeColors(buf);
        ClientFillStrokeColorsConfig excluded = ShowCategoryInPacket.readFillStrokeColors(buf);
        return new ClientConnectionsColorsConfig(locked, available, affordable, unlocked, excluded);
    }

    public static ClientFillStrokeColorsConfig readFillStrokeColors(class_2540 buf) {
        ClientColorConfig fill = ShowCategoryInPacket.readColor(buf);
        ClientColorConfig stroke = ShowCategoryInPacket.readColor(buf);
        return new ClientFillStrokeColorsConfig(fill, stroke);
    }

    public static ClientColorConfig readColor(class_2540 buf) {
        int argb = buf.readInt();
        return new ClientColorConfig(argb);
    }

    public static ClientSkillConfig readSkill(class_2540 buf) {
        String id = buf.method_19772();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.method_19772();
        boolean isRoot = buf.readBoolean();
        return new ClientSkillConfig(id, x, y, definition, isRoot);
    }

    public static ClientSkillConnectionConfig readSkillConnection(class_2540 buf) {
        String skillAId = buf.method_19772();
        String skillBId = buf.method_19772();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionConfig(skillAId, skillBId, bidirectional);
    }

    public ClientCategoryData getCategory() {
        return this.category;
    }
}

