/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class ConnectionBatchedRenderer {
    private final Int2ObjectMap<List<TriangleEmit>> strokeBatch = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<List<TriangleEmit>> fillBatch = new Int2ObjectOpenHashMap();

    public void emitConnection(class_4587 matrices, float startX, float startY, float endX, float endY, boolean bidirectional, int fillColor, int strokeColor) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        this.emitLine(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 3.0f);
        if (!bidirectional) {
            this.emitArrow(this.strokeBatch, matrix, strokeColor, startX, startY, endX, endY, 8.0f);
        }
        this.emitLine(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 1.0f);
        if (!bidirectional) {
            this.emitArrow(this.fillBatch, matrix, fillColor, startX, startY, endX, endY, 6.0f);
        }
    }

    private void emitLine(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f side = new Vector2f(endX, endY).sub(startX, startY).normalize().perpendicular().mul(thickness / 2.0f);
        this.emitTriangle(batch, matrix, color, startX + side.x, startY + side.y, startX - side.x, startY - side.y, endX + side.x, endY + side.y);
        this.emitTriangle(batch, matrix, color, endX - side.x, endY - side.y, endX + side.x, endY + side.y, startX - side.x, startY - side.y);
    }

    private void emitArrow(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float startX, float startY, float endX, float endY, float thickness) {
        Vector2f center = new Vector2f(endX, endY).add(startX, startY).div(2.0f);
        Vector2f normal = new Vector2f(endX, endY).sub(startX, startY).normalize();
        Vector2f forward = new Vector2f((Vector2fc)normal).mul(thickness);
        Vector2f backward = new Vector2f((Vector2fc)forward).div(-2.0f);
        Vector2f back = new Vector2f((Vector2fc)center).add((Vector2fc)backward);
        Vector2f side = new Vector2f((Vector2fc)backward).perpendicular().mul(class_3532.method_15355((float)3.0f));
        this.emitTriangle(batch, matrix, color, center.x + forward.x, center.y + forward.y, back.x - side.x, back.y - side.y, back.x + side.x, back.y + side.y);
    }

    private void emitTriangle(Int2ObjectMap<List<TriangleEmit>> batch, Matrix4f matrix, int color, float x1, float y1, float x2, float y2, float x3, float y3) {
        Vector3f v1 = matrix.transformPosition(new Vector3f(x1, y1, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(x2, y2, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(x3, y3, 0.0f));
        List emits = (List)batch.computeIfAbsent(color, key -> new ArrayList());
        emits.add(new TriangleEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z));
    }

    public void draw() {
        RenderSystem.setShader(class_757::method_34539);
        this.drawBatch(this.strokeBatch);
        this.drawBatch(this.fillBatch);
    }

    private void drawBatch(Int2ObjectMap<List<TriangleEmit>> batch) {
        RenderSystem.setShader(class_757::method_34539);
        for (Int2ObjectMap.Entry entry : batch.int2ObjectEntrySet()) {
            int color = entry.getIntKey();
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27379, class_290.field_1592);
            for (TriangleEmit emit : (List)entry.getValue()) {
                bufferBuilder.method_22912((double)emit.x1, (double)emit.y1, (double)emit.z1).method_1344();
                bufferBuilder.method_22912((double)emit.x2, (double)emit.y2, (double)emit.z2).method_1344();
                bufferBuilder.method_22912((double)emit.x3, (double)emit.y3, (double)emit.z3).method_1344();
            }
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        }
        batch.clear();
    }

    private record TriangleEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
    }
}

