/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.server.data.CategoryData;

public class PlayerData {
    private final Map<ResourceLocation, CategoryData> categories;

    private PlayerData(Map<ResourceLocation, CategoryData> categories) {
        this.categories = categories;
    }

    public static PlayerData empty() {
        return new PlayerData(new HashMap<ResourceLocation, CategoryData>());
    }

    public static PlayerData read(CompoundTag nbt) {
        HashMap<ResourceLocation, CategoryData> categories = new HashMap<ResourceLocation, CategoryData>();
        CompoundTag categoriesNbt = nbt.m_128469_("categories");
        for (String id : categoriesNbt.m_128431_()) {
            Tag elementNbt = categoriesNbt.m_128423_(id);
            if (!(elementNbt instanceof CompoundTag)) continue;
            CompoundTag categoryNbt = (CompoundTag)elementNbt;
            categories.put(SkillsMod.convertIdentifier(new ResourceLocation(id)), CategoryData.read(categoryNbt));
        }
        return new PlayerData(categories);
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        CompoundTag categoriesNbt = new CompoundTag();
        for (Map.Entry<ResourceLocation, CategoryData> entry : this.categories.entrySet()) {
            categoriesNbt.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().writeNbt(new CompoundTag()));
        }
        nbt.m_128365_("categories", (Tag)categoriesNbt);
        return nbt;
    }

    public boolean isCategoryUnlocked(CategoryConfig category) {
        CategoryData categoryData = this.categories.get(category.id());
        if (categoryData != null) {
            return categoryData.isUnlocked();
        }
        return category.general().unlockedByDefault();
    }

    public CategoryData getOrCreateCategoryData(CategoryConfig category) {
        return this.categories.computeIfAbsent(category.id(), key -> CategoryData.create(category.general()));
    }

    public void removeCategoryData(CategoryConfig category) {
        this.categories.remove(category.id());
    }
}

