/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2105;
import net.minecraft.class_5455;
import net.minecraft.class_6885;
import net.minecraft.class_9322;
import net.minecraft.class_9329;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public final class ItemStackCondition
implements Operation<class_1799, Boolean> {
    private final Optional<class_6885<class_1792>> optItemEntries;
    private final Optional<class_2105> optNbt;
    private final Optional<class_9329> optComponents;

    private ItemStackCondition(Optional<class_6885<class_1792>> optItemEntries, Optional<class_2105> optNbt, Optional<class_9329> optComponents) {
        this.optItemEntries = optItemEntries;
        this.optNbt = optNbt;
        this.optComponents = optComponents;
    }

    public static void register() {
        BuiltinPrototypes.ITEM_STACK.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, ItemStackCondition::parse);
    }

    public static Result<ItemStackCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(LegacyUtils.wrapNoUnused(rootObject -> ItemStackCondition.parse(rootObject, context), context));
    }

    public static Result<ItemStackCondition, Problem> parse(JsonObject rootObject, OperationConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<class_6885<class_1792>> optItem = rootObject.get("item").getSuccess().flatMap(itemElement -> BuiltinJson.parseItemOrItemTag(itemElement).ifFailure(problems::add).getSuccess());
        Optional<class_2105> optNbt = rootObject.get("nbt").getSuccess().flatMap(stateElement -> BuiltinJson.parseNbtPredicate(stateElement).ifFailure(problems::add).getSuccess());
        Optional<class_9329> optComponents = rootObject.get("components").getSuccess().flatMap(stateElement -> BuiltinJson.parseComponentPredicate(stateElement, (class_5455)context.getServer().method_30611()).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new ItemStackCondition(optItem, optNbt, optComponents));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(class_1799 itemStack) {
        return Optional.of(this.optItemEntries.map(arg_0 -> ((class_1799)itemStack).method_53187(arg_0)).orElse(true) != false && this.optNbt.map(nbt -> nbt.method_9074(itemStack)).orElse(true) != false && this.optComponents.map(components -> components.method_57864((class_9322)itemStack)).orElse(true) != false);
    }
}

