/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8690;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4fc;

public class TextureBatchedRenderer {
    private final Map<class_2960, List<TextureEmit>> batch = new HashMap<class_2960, List<TextureEmit>>();

    public void emitTexture(class_332 context, class_2960 texture, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitSprite(class_332 context, class_1058 sprite, class_8690 scaling, int x, int y, int width, int height, Vector4fc color) {
        if (scaling instanceof class_8690.class_8693) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
        } else if (scaling instanceof class_8690.class_8694) {
            class_8690.class_8694 tile = (class_8690.class_8694)scaling;
            this.emitSpriteTile(context, sprite, tile, x, y, width, height, color);
        } else if (scaling instanceof class_8690.class_8691) {
            class_8690.class_8691 nineSlice = (class_8690.class_8691)scaling;
            this.emitSpriteNineSlice(context, sprite, nineSlice, x, y, width, height, color);
        }
    }

    private void emitSpriteTile(class_332 context, class_1058 sprite, class_8690.class_8694 tile, int x, int y, int width, int height, Vector4fc color) {
        if (width <= 0 || height <= 0 || tile.comp_1644() <= 0 || tile.comp_1645() <= 0) {
            return;
        }
        for (int tileX = 0; tileX < width; tileX += tile.comp_1644()) {
            int tileWidth = Math.min(tile.comp_1644(), width - tileX);
            for (int tileY = 0; tileY < height; tileY += tile.comp_1645()) {
                int tileHeight = Math.min(tile.comp_1645(), height - tileY);
                this.emitSpriteStretch(context, sprite, x + tileX, y + tileY, tileWidth, tileHeight, color);
            }
        }
    }

    private void emitSpriteNineSlice(class_332 context, class_1058 sprite, class_8690.class_8691 nineSlice, int x, int y, int width, int height, Vector4fc color) {
        int tileWidth;
        int tileX;
        if (width == nineSlice.comp_1637() && height == nineSlice.comp_1638()) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
            return;
        }
        class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
        int left = Math.min(border.comp_1640(), width / 2);
        int top = Math.min(border.comp_1641(), height / 2);
        int right = Math.min(border.comp_1642(), width / 2);
        int bottom = Math.min(border.comp_1643(), height / 2);
        if (width == nineSlice.comp_1637()) {
            this.emitTextureBatched(context, sprite.method_45852(), x, y, x + width, y + top, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
                int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.method_45852(), x, y + tileY, x + nineSlice.comp_1637(), y + tileY + tileHeight, sprite.method_4594(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            }
            this.emitTextureBatched(context, sprite.method_45852(), x, y + height - bottom, x + width, y + height, sprite.method_4594(), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4575(), color);
            return;
        }
        if (height == nineSlice.comp_1638()) {
            this.emitTextureBatched(context, sprite.method_45852(), x, y, x + left, y + height, sprite.method_4594(), sprite.method_4593(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
            for (int tileX2 = left; tileX2 < width - right; tileX2 += nineSlice.comp_1637() - left - right) {
                int tileWidth2 = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX2);
                this.emitTextureBatched(context, sprite.method_45852(), x + tileX2, y, x + tileX2 + tileWidth2, y + nineSlice.comp_1638(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4580((float)(left + tileWidth2) / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
            }
            this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y, x + width, y + height, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4577(), sprite.method_4575(), color);
            return;
        }
        this.emitTextureBatched(context, sprite.method_45852(), x, y, x + left, y + right, sprite.method_4594(), sprite.method_4593(), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)right / (float)nineSlice.comp_1637()), color);
        this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y, x + width, y + top, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4577(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
        this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y + height - bottom, x + width, y + height, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4575(), color);
        this.emitTextureBatched(context, sprite.method_45852(), x, y + height - bottom, x + left, y + height, sprite.method_4594(), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
        for (tileX = left; tileX < width - right; tileX += nineSlice.comp_1637() - left - right) {
            tileWidth = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX);
            this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y, x + tileX + tileWidth, y + top, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4593(), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), color);
            this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y + height - bottom, x + tileX + tileWidth, y + height, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)(nineSlice.comp_1638() - bottom) / (float)nineSlice.comp_1638()), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4575(), color);
        }
        for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
            int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
            this.emitTextureBatched(context, sprite.method_45852(), x, y + tileY, x + left, y + tileY + tileHeight, sprite.method_4594(), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            this.emitTextureBatched(context, sprite.method_45852(), x + width - right, y + tileY, x + width, y + tileY + tileHeight, sprite.method_4580((float)(nineSlice.comp_1637() - right) / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4577(), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
        }
        for (tileX = left; tileX < width - right; tileX += nineSlice.comp_1637() - left - right) {
            tileWidth = Math.min(nineSlice.comp_1637() - left - right, width - right - tileX);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.comp_1638() - top - bottom) {
                int tileHeight = Math.min(nineSlice.comp_1638() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.method_45852(), x + tileX, y + tileY, x + tileX + tileWidth, y + tileY + tileHeight, sprite.method_4580((float)left / (float)nineSlice.comp_1637()), sprite.method_4570((float)top / (float)nineSlice.comp_1638()), sprite.method_4580((float)(left + tileWidth) / (float)nineSlice.comp_1637()), sprite.method_4570((float)(top + tileHeight) / (float)nineSlice.comp_1638()), color);
            }
        }
    }

    private void emitSpriteStretch(class_332 context, class_1058 sprite, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, sprite.method_45852(), x, y, x + width, y + height, sprite.method_4594(), sprite.method_4593(), sprite.method_4577(), sprite.method_4575(), color);
    }

    private void emitTextureBatched(class_332 context, class_2960 texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = context.method_51448().method_23760().method_23761();
        Vector3f v1 = matrix.transformPosition(new Vector3f(minX, minY, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(minX, maxY, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(maxX, maxY, 0.0f));
        Vector3f v4 = matrix.transformPosition(new Vector3f(maxX, minY, 0.0f));
        emits.add(new TextureEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, v4.x, v4.y, v4.z, minU, minV, maxU, maxV, color));
    }

    public void draw() {
        for (Map.Entry<class_2960, List<TextureEmit>> entry : this.batch.entrySet()) {
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (TextureEmit emit : entry.getValue()) {
                bufferBuilder.method_22912(emit.x1, emit.y1, emit.z1).method_22913(emit.minU, emit.minV).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                bufferBuilder.method_22912(emit.x2, emit.y2, emit.z2).method_22913(emit.minU, emit.maxV).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                bufferBuilder.method_22912(emit.x3, emit.y3, emit.z3).method_22913(emit.maxU, emit.maxV).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
                bufferBuilder.method_22912(emit.x4, emit.y4, emit.z4).method_22913(emit.maxU, emit.minV).method_22915(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w());
            }
            class_1921.method_62277((class_2960)entry.getKey()).method_60895(bufferBuilder.method_60800());
        }
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4fc color) {
    }
}

